/*
 * Decompiled with CFR 0.152.
 */
package parsers.cdpp;

import components.FilesMap;
import components.Helper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import models.simulation.IEmitter;
import models.simulation.MessageCA;
import models.simulation.Model;
import models.simulation.Port;
import models.simulation.Structure;
import models.simulation.StructureInfo;
import parsers.ILogParser;
import parsers.shared.Ma;
import parsers.shared.Val;

public class CellDevs
implements ILogParser {
    private static final String TEMPLATE = "{\"value\":${0}}";

    @Override
    public Structure Parse(FilesMap files) throws IOException {
        Ma maParser = new Ma();
        Structure structure = maParser.ParseCA(files.FindStream(".ma"), TEMPLATE);
        structure.setInfo(new StructureInfo(files.FindName(".ma"), "CDpp", "Cell-DEVS"));
        CellDevs.FixStructure(structure);
        this.ParseLog(structure, files.FindStream(".val"), files.FindStream(".log"));
        return structure;
    }

    private static void FixStructure(Structure structure) {
        structure.getNodes().forEach(m -> structure.CreatePort((Model)m, "out", Port.Type.OUTPUT, TEMPLATE));
    }

    private void ParseLog(Structure structure, InputStream val, InputStream log) throws IOException {
        Port port0 = structure.FindPort(structure.getNodes().get(0), "out");
        List<MessageCA> initial = structure.MergeFrames(structure.GlobalFrame(port0), structure.RowFrame(port0));
        Val valParser = new Val();
        if (val != null) {
            initial = structure.MergeFrames(initial, valParser.Parse(val, structure));
        }
        structure.getTimesteps().add("00:00:00:000");
        ArrayList messages = new ArrayList();
        Helper.ReadFile(log, l -> {
            if (!l.startsWith("Mensaje Y")) {
                return;
            }
            String[] split = (String[])Arrays.stream(l.split("/")).map(s -> s.trim()).toArray(String[]::new);
            String[] tmp1 = split[2].split("\\(");
            String[] tmp2 = tmp1[1].substring(0, tmp1[1].length() - 1).split(",");
            String t = split[1];
            String v = split[4].split("\\s+")[0];
            int[] c = new int[3];
            if (tmp2.length < 2) {
                return;
            }
            c[0] = Integer.parseInt(tmp2[0]);
            c[1] = Integer.parseInt(tmp2[1]);
            c[2] = tmp2.length == 2 ? 0 : Integer.parseInt(tmp2[2]);
            BigDecimal number = new BigDecimal(v);
            v = number.stripTrailingZeros().toPlainString();
            if (!structure.getTimesteps().contains(t)) {
                structure.getTimesteps().add(t);
            }
            messages.add(new MessageCA(structure.getTimesteps().size() - 1, (IEmitter)port0, c, v));
        });
        initial.addAll(messages);
        structure.setMessages(initial);
    }

    @Override
    public Boolean Validate(FilesMap files) throws IOException {
        InputStream ma = (InputStream)files.get(files.FindKey(".ma"));
        InputStream log = (InputStream)files.get(files.FindKey(".log"));
        if (ma == null || log == null) {
            return false;
        }
        List<String> lines = Helper.ReadNLines(ma, 10);
        ma.reset();
        long count = lines.stream().filter(l -> l.contains("type") && l.contains("cell")).count();
        return count > 0L;
    }
}

