/*
 * Decompiled with CFR 0.152.
 */
package parsers.shared;

import components.FilesMap;
import components.Helper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import models.style.Bucket;
import models.style.LayerStyle;
import models.style.Style;

public class Palette {
    public Style ParseTypeA(InputStream pal) throws IOException {
        Style style = new Style();
        style.getLayers().add(new LayerStyle());
        LayerStyle layer = style.getLayers().get(0);
        Helper.ReadFile(pal, l -> {
            if (l == null || l.isEmpty()) {
                return;
            }
            if (!l.startsWith("[")) {
                throw new RuntimeException("File format does not correspond to a type A palette.");
            }
            String[] split = l.split(", | |,");
            int r = Integer.parseInt(split[1]);
            int g = Integer.parseInt(split[2]);
            int b = Integer.parseInt(split[3]);
            String[] bucket = split[0].substring(1, split[0].length() - 1).split(";");
            float start = Float.parseFloat(bucket[0]);
            float end = Float.parseFloat(bucket[1]);
            layer.getBuckets().add(new Bucket(start, end, new int[]{r, g, b}));
        });
        return style;
    }

    public Style ParseTypeB(InputStream pal) throws IOException {
        Style style = new Style();
        style.getLayers().add(new LayerStyle());
        LayerStyle layer = style.getLayers().get(0);
        ArrayList ranges = new ArrayList();
        ArrayList colors = new ArrayList();
        Helper.ReadFile(pal, l -> {
            if (l == null || l.isEmpty()) {
                return;
            }
            String[] split = l.split(",");
            if (split.length == 2) {
                ranges.add(new float[]{Float.parseFloat(split[0]), Float.parseFloat(split[1])});
            } else if (split.length == 3) {
                colors.add(new int[]{Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2])});
            }
        });
        if (ranges.size() != colors.size()) {
            throw new RuntimeException("Ranges and colors length must match in palette type B.");
        }
        for (int i = 0; i < ranges.size(); ++i) {
            layer.getBuckets().add(new Bucket(((float[])ranges.get(i))[0], ((float[])ranges.get(i))[1], new int[]{((int[])colors.get(i))[0], ((int[])colors.get(i))[1], ((int[])colors.get(i))[2]}));
        }
        return style;
    }

    public Style Parse(FilesMap files) throws IOException {
        BufferedInputStream pal = files.FindStream(".pal");
        if (pal == null) {
            return null;
        }
        List<String> lines = Helper.ReadNLines(pal, 1);
        if (lines.size() < 1) {
            return null;
        }
        ((InputStream)pal).reset();
        if (lines.get(0).contains("VALIDSAVEDFILE")) {
            return this.ParseTypeB(pal);
        }
        if (lines.get(0).startsWith("[")) {
            return this.ParseTypeA(pal);
        }
        return null;
    }
}

