/*******************************************************************
*
*  DESCRIPTION: Atomic Model Sower
*
*  AUTHOR: Bruno St-Aubin
*
*  EMAIL: mailto://staubibr@gmail.com
*
*  DATE: 28-10-2017
*
*******************************************************************/

#ifndef __SOWER_H
#define __SOWER_H

#include "request.h"
#include "atomic.h"

class sower : public Atomic
{
	public:
		sower( const string &name = "sower" );

		virtual string className() const ;
	protected:
		Model &initFunction();
		Model &externalFunction( const ExternalMessage & );
		Model &internalFunction( const InternalMessage & );
		Model &outputFunction( const InternalMessage & );

	private:
		const Port &in_id;
		const Port &in_surface;
		const Port &in_type;
		Port &out_id;
		TaskRequest request;
		double speed;
};

inline
string sower::className() const
{
	return "sower" ;
}

#endif
