/*******************************************************************
*
*  DESCRIPTION: Atomic Model Decider - decides after a time delay if the person is
*  ok, needs extra checks, or is turned away.
*
*  AUTHOR: Scott Stewart
*
*  EMAIL: wtime@live.ca
*
*  DATE: 1/3/2016
*
*******************************************************************/
#ifndef __DECIDER_H
#define __DECIDER_H

#include "atomic.h"     // class Atomic

class Distribution ; //Forward declaration

class Decider : public Atomic
{
public:
	Decider( const string &name = "Decider" );    //Default constructor for Line

	virtual string className() const ;

protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &next_person;
	Port &ok;
	Port &turn_away;
	Port &extra_checks;
	Port &is_free;

	int id;
	Distribution * dist;
	Distribution &distribution()
			{return *dist;}
};	// class Reception

// ** inline ** //
inline
string Decider::className() const
{
	return "Decider" ;
}

#endif   //__DECIDER_H
