/*******************************************************************
*
*  DESCRIPTION: Atomic Model SecondaryDecider - decides after a time delay if the person is
*  ok or is turned away.
*
*  AUTHOR: Scott Stewart
*
*  EMAIL: wtime@live.ca
*
*  DATE: 4/3/2016
*
*******************************************************************/
#ifndef __SECONDARYDECIDER_H
#define __SECONDARYDECIDER_H

#include "atomic.h"     // class Atomic

class Distribution ; //Forward declaration

class SecondaryDecider : public Atomic
{
public:
	SecondaryDecider( const string &name = "SecondaryDecider" );    //Default constructor for Line

	virtual string className() const ;

protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &next_person;
	Port &ok;
	Port &turn_away;
	Port &is_free;

	int id;
	Distribution * dist;
	Distribution &distribution()
			{return *dist;}
};

// ** inline ** //
inline
string SecondaryDecider::className() const
{
	return "SecondaryDecider" ;
}

#endif   //__SECONDARYDECIDER_H
