#include <math.h>
#include <assert.h> 
#include <memory>
#include <iomanip>
#include <iostream>
#include <fstream>
#include <string>
#include <chrono>
#include <algorithm>
#include <limits>
#include <boost/simulation/pdevs/atomic.hpp>
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string.hpp>
#include <boost/simulation.hpp>

#include "../vendor/britime.hpp"
#include "../vendor/input_event_stream.hpp"
#include "../data_structures/message.hpp"

//Include atomic models that make up the coupled model
#include "../vendor/portConversor.hpp"
#include "../vendor/filterPort.hpp"
#include "../atomics/line.hpp"
#include "../atomics/decider.hpp"
#include "../atomics/secondaryDecider.hpp"



using namespace std;
using namespace boost::simulation;
using namespace boost::simulation::pdevs;
using namespace boost::simulation::pdevs::basic_models;


using hclock = chrono::high_resolution_clock;
using Time =BRITime; 
using Message = Message_t; 


int main(int argc, char ** argv) {

  if (argc < 2) {
   cout << "you are using this program with wrong parameters. Te program should be invoked as follow:";
   cout << argv[0] << " path to the input file " << endl;
   return 1;  
  }
  
  string test_file = argv[1];
  ifstream file(test_file);
  string str;
  string file_contents;
  while (getline(file, str)){
    file_contents += str;
    file_contents.push_back('\n');
  }  
    
  string m_input;
  m_input = file_contents;

  cout << "model input:" << endl;
  cout << m_input << endl;

  shared_ptr<istringstream> piss1{ new istringstream{} };
  piss1->str(m_input);

  auto input_test_generator = make_atomic_ptr<input_event_stream<Time, Message, Time, Message>, shared_ptr<istringstream>, Time>(piss1, Time(0),
                [](const string& s, Time& t_next, Message& m_next)->void{ //parsing function
        
        string aux;
        m_next.clear();          
        istringstream ss;
                    
        ss.str(s);
        

        ss >> t_next;        
        ss >> m_next.port;
        ss >> m_next.value;
        
        
        string thrash;
        ss >> thrash;
        if ( 0 != thrash.size()) throw exception();         
  });
  

  //ATOMIC MODELS

  // ATOMIC MODELS FOR COUPLED MODEL frontDesk
  auto line1 = make_atomic_ptr<line<Time, Message>>();
  auto decider1 = make_atomic_ptr<decider<Time, Message>,double,double>(7.0,4.0);
  auto nextPerson_pc1 = make_atomic_ptr<portConversor<Time, Message>,string>(string("next_person"));
  auto readyForNext_pc1 = make_atomic_ptr<portConversor<Time, Message>,string>(string("ready_for_next"));
  auto isFree_f1 = make_atomic_ptr<filter<Time, Message>,string>(string("is_free"));
  auto ok_f1 = make_atomic_ptr<filter<Time, Message>,string>(string("ok")); 
  auto extraChecks_f1 = make_atomic_ptr<filter<Time, Message>,string>(string("extra_checks"));
  auto turnAway_f1 = make_atomic_ptr<filter<Time, Message>,string>(string("turn_away"));

  //ATOMIC MODELS FOR COUPLED MODEL Turn_away_N_ok1
  auto turnAway_f2 = make_atomic_ptr<filter<Time, Message>,string>(string("turn_away"));
  auto ok_f2 = make_atomic_ptr<filter<Time, Message>,string>(string("ok")); 

  //ATOMIC MODELS FOR COUPLED MODEL ExtraC1
  auto extraChecks_f2 = make_atomic_ptr<filter<Time, Message>,string>(string("extra_checks"));
  
  //ATOMIC MODELS FOR COUPLED MODEL NewP1
  auto new_person_pc1 = make_atomic_ptr<portConversor<Time, Message>,string>(string("new_person"));

  // ATOMIC MODELS FOR COUPLED MODEL carCheck
  auto line2 = make_atomic_ptr<line<Time, Message>>();
  auto decider2 = make_atomic_ptr<decider<Time, Message>,double,double>(5.0,4.0);
  auto nextPerson_pc2 = make_atomic_ptr<portConversor<Time, Message>,string>(string("next_person"));
  auto readyForNext_pc2 = make_atomic_ptr<portConversor<Time, Message>,string>(string("ready_for_next"));
  auto isFree_f2 = make_atomic_ptr<filter<Time, Message>,string>(string("is_free"));
  auto ok_f3 = make_atomic_ptr<filter<Time, Message>,string>(string("ok")); 
  auto extraChecks_f3 = make_atomic_ptr<filter<Time, Message>,string>(string("extra_checks"));
  auto turnAway_f3 = make_atomic_ptr<filter<Time, Message>,string>(string("turn_away"));

  // ATOMIC MODELS FOR COUPLED MODEL interview
  auto line3 = make_atomic_ptr<line<Time, Message>>();
  auto secondaryDecider1 = make_atomic_ptr<secondaryDecider<Time, Message>,double,double>(20.0,4.0);
  auto nextPerson_pc3 = make_atomic_ptr<portConversor<Time, Message>,string>(string("next_person"));
  auto readyForNext_pc3 = make_atomic_ptr<portConversor<Time, Message>,string>(string("ready_for_next"));
  auto isFree_f3 = make_atomic_ptr<filter<Time, Message>,string>(string("is_free"));
  auto ok_f5 = make_atomic_ptr<filter<Time, Message>,string>(string("ok")); 
  auto turnAway_f5 = make_atomic_ptr<filter<Time, Message>,string>(string("turn_away"));
  
  //ATOMIC MODELS FOR COUPLED MODEL Turn_away_N_ok2
  auto turnAway_f4 = make_atomic_ptr<filter<Time, Message>,string>(string("turn_away"));
  auto ok_f4 = make_atomic_ptr<filter<Time, Message>,string>(string("ok")); 
  
  //ATOMIC MODELS FOR COUPLED MODEL ExtraC_NewP1
  auto extraChecks_f4 = make_atomic_ptr<filter<Time, Message>,string>(string("extra_checks"));
  auto new_person_pc2 = make_atomic_ptr<portConversor<Time, Message>,string>(string("new_person"));



  //COUPLED MODELS

  //COUPLED MODEL 1 = frontDesk
  shared_ptr<flattened_coupled<Time, Message>> frontDesk(new flattened_coupled<Time, Message>(
  {line1, decider1, nextPerson_pc1, readyForNext_pc1, isFree_f1, ok_f1, extraChecks_f1, turnAway_f1}, //names of models in the coupled model
  {line1}, //EICs
  {{line1,nextPerson_pc1},{nextPerson_pc1,decider1},{decider1,isFree_f1},{isFree_f1,readyForNext_pc1},{readyForNext_pc1,line1},{decider1,ok_f1},//ICs
  {decider1,extraChecks_f1},{decider1,turnAway_f1}}, //ICS
  {ok_f1,extraChecks_f1,turnAway_f1}//EOC
  ));  
  
  //COUPLED MODEL 2 = Turn_away_N_ok1
  shared_ptr<flattened_coupled<Time, Message>> Turn_away_N_ok1(new flattened_coupled<Time, Message>(
  {turnAway_f2,ok_f2}, //names of models in the coupled model
  {turnAway_f2,ok_f2}, //EICs
  {{}},//ICs
  {turnAway_f2,ok_f2}//EOC
  ));

  //COUPLED MODEL 3 = ExtraC1 
  shared_ptr<flattened_coupled<Time, Message>> ExtraC1(new flattened_coupled<Time, Message>(
  {extraChecks_f2}, //names of models in the coupled model
  {extraChecks_f2}, //EICs
  {{}},//ICs
  {extraChecks_f2}//EOC
  ));

  //COUPLED MODEL 4 = NewP1 
  shared_ptr<flattened_coupled<Time, Message>> NewP1(new flattened_coupled<Time, Message>(
  {new_person_pc1}, //names of models in the coupled model
  {new_person_pc1}, //EICs
  {{}},//ICs
  {new_person_pc1}//EOC
  ));

  //COUPLED MODEL 5 = carCheck
  shared_ptr<flattened_coupled<Time, Message>> carCheck(new flattened_coupled<Time, Message>(
  {line2, decider2, nextPerson_pc2, readyForNext_pc2, isFree_f2, ok_f3, extraChecks_f3, turnAway_f3}, //names of models in the coupled model
  {line2}, //EICs
  {{line2,nextPerson_pc2},{nextPerson_pc2,decider2},{decider2,isFree_f2},{isFree_f2,readyForNext_pc2},{readyForNext_pc2,line2},{decider2,ok_f3},//ICs
  {decider2,extraChecks_f3},{decider2,turnAway_f3}}, //ICS
  {ok_f3,extraChecks_f3,turnAway_f3}//EOC
  )); 

  //COUPLED MODEL 6 = interview
  shared_ptr<flattened_coupled<Time, Message>> interview(new flattened_coupled<Time, Message>(
  {line3, secondaryDecider1, nextPerson_pc3, readyForNext_pc3, isFree_f3, ok_f5, turnAway_f5}, //names of models in the coupled model
  {line3}, //EICs
  {{line3,nextPerson_pc3},{nextPerson_pc3,secondaryDecider1},{secondaryDecider1,isFree_f3},{isFree_f3,readyForNext_pc3},{readyForNext_pc3,line3},{secondaryDecider1,ok_f5},//ICs
  {secondaryDecider1,turnAway_f5}}, //ICS
  {ok_f5,turnAway_f5}//EOC
  ));   
  
  //COUPLED MODEL 7 = Turn_away_N_ok2
  shared_ptr<flattened_coupled<Time, Message>> Turn_away_N_ok2(new flattened_coupled<Time, Message>(
  {turnAway_f4,ok_f4}, //names of models in the coupled model
  {turnAway_f4,ok_f4}, //EICs
  {{}},//ICs
  {turnAway_f4,ok_f4}//EOC
  ));

  //COUPLED MODEL 8 = ExtraC_NewP1
  shared_ptr<flattened_coupled<Time, Message>> ExtraC_NewP1(new flattened_coupled<Time, Message>(
  {extraChecks_f4,new_person_pc2}, //names of models in the coupled model
  {extraChecks_f4}, //EICs
  {{extraChecks_f4,new_person_pc2}},//ICs
  {new_person_pc2}//EOC
  ));

  //COUPLED MODEL 9 = extraChecks
  shared_ptr<flattened_coupled<Time, Message>> extraChecks(new flattened_coupled<Time, Message>(
  {NewP1,carCheck,interview,Turn_away_N_ok2,ExtraC_NewP1}, //names of models in the coupled model
  {NewP1}, //EICs
  {{NewP1,carCheck},{carCheck,ExtraC_NewP1},{carCheck,Turn_away_N_ok2},{ExtraC_NewP1,interview}},//ICs
  {interview,Turn_away_N_ok2}//EOC
  ));

  
  //COUPLED MODEL 10 = borderTop
  shared_ptr<flattened_coupled<Time, Message>> borderTop(new flattened_coupled<Time, Message>(
  {frontDesk,Turn_away_N_ok1,ExtraC1,extraChecks}, //names of models in the coupled model
  {frontDesk}, //EICs
  {{frontDesk,ExtraC1},{frontDesk,Turn_away_N_ok1},{ExtraC1,extraChecks}},//ICs
  {Turn_away_N_ok1,extraChecks}//EOC
  ));

  //COUPLED MODEL 11 = BORDERTOP_TEST
  shared_ptr<flattened_coupled<Time, Message>> BORDERTOP_TEST(new flattened_coupled<Time, Message>(
  {input_test_generator, borderTop}, //names of models in the coupled model
  {}, //EICs
  {{input_test_generator,borderTop}},//ICs
  {borderTop}//EOC
  ));  
  
 
    cout << "Preparing runner" << endl;
    Time initial_time = Time(0);
    ofstream out_data("borderTop_test_output.txt");  
    runner<Time, Message> r(BORDERTOP_TEST, initial_time, out_data, [](ostream& os, Message m){ os << m;});
    
    Time end_time = Time(1000000); //FINISHING TIME OF THE SIMULATION. 

    cout << "Starting simulation until time: " << end_time << "seconds" << endl;
    auto start = hclock::now();
    end_time = r.runUntil(end_time);
    auto elapsed = chrono::duration_cast<std::chrono::duration<double, std::ratio<1>>> (hclock::now() - start).count();     
    cout << "Finished simulation with time: " << end_time << "sec" << endl;
    cout << "Simulation took: " << elapsed << "sec" << endl;
    return 0;
}



    

   
