#include <math.h>
#include <assert.h> 
#include <memory>
#include <iomanip>
#include <iostream>
#include <fstream>
#include <string>
#include <chrono>
#include <algorithm>
#include <limits>
#include <boost/simulation/pdevs/atomic.hpp>
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string.hpp>
#include <boost/simulation.hpp>

#include "../../vendor/britime.hpp"
#include "../../vendor/input_event_stream.hpp"
#include "../../data_structures/message.hpp"

//Include atomic models that make up the coupled model
#include "../../vendor/portConversor.hpp"
#include "../../vendor/filterPort.hpp"
#include "../../atomics/line.hpp"
#include "../../atomics/decider.hpp"



using namespace std;
using namespace boost::simulation;
using namespace boost::simulation::pdevs;
using namespace boost::simulation::pdevs::basic_models;


using hclock = chrono::high_resolution_clock;
using Time =BRITime; 
using Message = Message_t; 


int main(int argc, char ** argv) {

  if (argc < 2) {
   cout << "you are using this program with wrong parameters. Te program should be invoked as follow:";
   cout << argv[0] << " path to the input file " << endl;
   return 1;  
  }
  
  string test_file = argv[1];
  ifstream file(test_file);
  string str;
  string file_contents;
  while (getline(file, str)){
    file_contents += str;
    file_contents.push_back('\n');
  }  
    
  string m_input;
  m_input = file_contents;

  cout << "model input:" << endl;
  cout << m_input << endl;

  shared_ptr<istringstream> piss1{ new istringstream{} };
  piss1->str(m_input);

  auto input_test_generator = make_atomic_ptr<input_event_stream<Time, Message, Time, Message>, shared_ptr<istringstream>, Time>(piss1, Time(0),
                [](const string& s, Time& t_next, Message& m_next)->void{ //parsing function
        
        string aux;
        m_next.clear();          
        istringstream ss;
                    
        ss.str(s);
        

        ss >> t_next;        
        ss >> m_next.port;
        ss >> m_next.value;
        
        
        string thrash;
        ss >> thrash;
        if ( 0 != thrash.size()) throw exception();         
  });
  
  
  // ATOMIC MODELS
  auto line1 = make_atomic_ptr<line<Time, Message>>();
  auto decider1 = make_atomic_ptr<decider<Time, Message>,double,double>(7.0,4.0);
  auto nextPerson_pc1 = make_atomic_ptr<portConversor<Time, Message>,string>(string("next_person"));
  auto readyForNext_pc1 = make_atomic_ptr<portConversor<Time, Message>,string>(string("ready_for_next"));
  auto isFree_f1 = make_atomic_ptr<filter<Time, Message>,string>(string("is_free"));
  auto ok_f1 = make_atomic_ptr<filter<Time, Message>,string>(string("ok")); 
  auto extraChecks_f1 = make_atomic_ptr<filter<Time, Message>,string>(string("extra_checks"));
  auto turnAway_f1 = make_atomic_ptr<filter<Time, Message>,string>(string("turn_away"));

  //COUPLED MODELS

  //COUPLED MODEL 1 = FRONTDESK
  shared_ptr<flattened_coupled<Time, Message>> frontDesk(new flattened_coupled<Time, Message>(
  {line1, decider1, nextPerson_pc1, readyForNext_pc1, isFree_f1, ok_f1, extraChecks_f1, turnAway_f1}, //names of models in the coupled model
  {line1}, //EICs
  {{line1,nextPerson_pc1},{nextPerson_pc1,decider1},{decider1,isFree_f1},{isFree_f1,readyForNext_pc1},{readyForNext_pc1,line1},{decider1,ok_f1},//ICs
  {decider1,extraChecks_f1},{decider1,turnAway_f1}}, //ICS
  {ok_f1,extraChecks_f1,turnAway_f1}//EOC
  ));  
  
  //COUPLED MODEL 2 = FRONTDESK_TEST
  shared_ptr<flattened_coupled<Time, Message>> FRONTDESK_TEST(new flattened_coupled<Time, Message>(
  {input_test_generator, frontDesk}, //names of models in the coupled model
  {}, //EICs
  {{input_test_generator,frontDesk}},//ICs
  {frontDesk}//EOC
  ));  
  
 
    cout << "Preparing runner" << endl;
    Time initial_time = Time(0);
    ofstream out_data("frontDesk_test_output.txt");  
    runner<Time, Message> r(FRONTDESK_TEST, initial_time, out_data, [](ostream& os, Message m){ os << m;});
    
    Time end_time = Time(1000000); //FINISHING TIME OF THE SIMULATION. 

    cout << "Starting simulation until time: " << end_time << "seconds" << endl;
    auto start = hclock::now();
    end_time = r.runUntil(end_time);
    auto elapsed = chrono::duration_cast<std::chrono::duration<double, std::ratio<1>>> (hclock::now() - start).count();     
    cout << "Finished simulation with time: " << end_time << "sec" << endl;
    cout << "Simulation took: " << elapsed << "sec" << endl;
    return 0;
}



    

   
