/*******************************************************************
*
*  DESCRIPTION: Atomic Model Line
*
*  AUTHOR: Scott Stewart
*
*  EMAIL: wtime@live.ca
*
*  DATE: 29/2/2016
*
*******************************************************************/
#ifndef __LINE_H
#define __LINE_H

#include <list>
#include "atomic.h"     // class Atomic

class Line : public Atomic
{
public:
	Line( const string &name = "Line" );    //Default constructor for Line

	virtual string className() const ;

protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &new_person;
	const Port &ready_for_next;
	Port &line_out;

	typedef list<Value> ElementList ;
	ElementList elements ;

	bool may_pass;

};	// class Reception

// ** inline ** //
inline
string Line::className() const
{
	return "Line" ;
}

#endif   //__LINE_H
