/*******************************************************************
*
*  DESCRIPTION: Atomic Model Audience
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carleton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/

#ifndef __AUDIENCE_H
#define __AUDIENCE_H

//#include <list>
#include "atomic.h"     // class Atomic

class Audience : public Atomic
{
public:
	Audience( const string &name = "Audience" );					//Default constructor
	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &audienceIn;
	Port &out;
	Port &audienceOut;
	int count1;
	int count2;
	int audienceNum;
};	// class Audience

// ** inline ** // 
inline
string Audience::className() const
{
	return "Audience" ;
}

#endif   //__AUDIENCE_H
