/*******************************************************************
*
*  DESCRIPTION: Atomic Model Onumpire
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carleton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/
#ifndef __ONUMPIRE_H
#define __ONUMPIRE_H


#include <list>
#include "atomic.h"     // class Atomic


// Onumpire class

class Onumpire : public Atomic
{
public:
	// Constructor
	Onumpire( const string &name = "Onumpire" );

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:

	// input ports
	const Port &wicket;

	// output port
	Port &yes_wicket;

   int out;
   int wicketin;

};	// class Onumpire

// ** inline ** //
inline
string Onumpire::className() const
{
	return "Onumpire";
}

#endif   //__ONUMPIRE_H
