/*******************************************************************
*
*  DESCRIPTION: Atomic Model Players
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carleton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/

/** include files **/
#include "players.h"      // class Queue
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )
#include "distri.h"        // class Distribution
#include "strutil.h"       // str2float( ... )
#include <stdlib.h>
#include <time.h>
/** public functions **/

/*******************************************************************
*  Function Name:Players
*  Description: The Players component will model how the game goes on.
*  The players will have a total ball number initially.
*  Players are currently divided into 2 parts, batting team and bowling team.
*  Batsman can score a run or hit a six or hit a boundary on each ball they get
*  Similarly bowler can get a wicket for each ball.
*  When their current ball number equals the total ball number, the game will be over.
*  With the game going on, the Players will output the score of the batting teams teams current score, whether bowling team got a wicket or not and as well, when game is over, it will output the final score and the total wicket fallen.
********************************************************************/
Players::Players( const string &name )
: Atomic( name )
, totalBallNumIn( addInputPort( "totalBallNumIn" ) )
, scoreOut( addOutputPort( "scoreOut" ) )
, totalOut( addOutputPort( "totalOut" ) )
, totalW( addOutputPort( "totalW" ) )
, startMatch( addInputPort( "startMatch" ) )
, startGame( addOutputPort( "startGame" ) )
{	score = 0;
	totalScore=0;
	currentBallNum=0;
	temp1;
	tempS;
	tempC;
	tempF;
	count = 0;
	count1 = 0;
	wicket = 1;
	try
		{
			dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );

			MASSERT( dist );

			for ( register int i = 0 ; i < dist->varCount() ; i++ )
			{
				string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar(i) ) ) ;
				dist->setVar( i, str2float( parameter ) ) ;
			}
		} catch( InvalidDistribution &e )
		{
			e.addText( "The model " + description() + " has distribution problems!" ) ;
			e.print(cerr);
			MTHROW( e ) ;
		} catch( MException &e )
		{
			MTHROW( e ) ;
		}

}

/*******************************************************************
* Function Name: initFunction
* Description:
* Precondition:
********************************************************************/
Model &Players::initFunction()
{
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Players::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == startMatch  && this->state() == passive)
	{
		start =int( (static_cast < long double > (msg.value())));
		holdIn( active, Time::Zero );
		count1 = 1;
	}
	if( msg.port() == totalBallNumIn )
	{	temp=static_cast <  long double > (msg.value());
		totalBallNum =int( (static_cast < long double > (msg.value())/10000));
		if (totalBallNum > 0)
		{	currentBallNum=1;
			temp1=20*( int((temp-totalBallNum*10000)/1000));
			tempS=20*( int((temp-totalBallNum*10000-temp1*50)/100));
			tempC=20*( int((temp-totalBallNum*10000-temp1*50-tempS*5)/10));
			tempF=20*((temp-totalBallNum*10000-temp1*50-tempS*5-tempC/2));
			if(rand()%100>=temp1){
				score=1;
				totalScore+=1;
				holdIn(active,  Time( static_cast<float>( fabs( distribution().get() ) ) ) );
			}
			else if(rand()%100>=tempS-tempF/2){
					score=6;
					totalScore+=6;
					holdIn(active,  Time( static_cast<float>( fabs( distribution().get() ) ) ) );
				}
            else if(rand()%100>=tempS/2){
            	  if(count<=10)
            	  {

					score=0;
					totalScore+=0;
					count++;
					holdIn(active,  Time( static_cast<float>( fabs( distribution().get() ) ) ) );
            	  }
            	  else passivate();
				}

				else if(rand()%100>=tempF/2){
					score=4;
					totalScore+=4;
					holdIn(active,  Time( static_cast<float>( fabs( distribution().get() ) ) ) );
				}

		}
   }
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Players::internalFunction( const InternalMessage &msg )
{
		if (currentBallNum < totalBallNum)
		{	currentBallNum ++;
			if(rand()%100>=temp1)
			{
					        score=1;
                            totalScore+=1;
					        holdIn(active,  Time( static_cast<float>( fabs( distribution().get() ) ) )  );
			}
			else
			{
					if(rand()%100>=tempS-tempF/2)
					{
							score=6;
							totalScore+=6;
							holdIn(active,  Time( static_cast<float>( fabs( distribution().get() ) ) )  );
					}
                    else if(rand()%100>=tempS/2)
					{
                    	if(count<=10)
                    	{
							score=0;
							totalScore+=0;
							count++;
							holdIn(active,  Time( static_cast<float>( fabs( distribution().get() ) ) )  );
					    }
                    	else passivate();

					}
					else if(rand()%100>=tempF/2)
					{
							score=4;
							totalScore+=4;
							holdIn(active,  Time( static_cast<float>( fabs( distribution().get() ) ) )  );
					}
			}
		}
		else
			passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Players::outputFunction( const InternalMessage &msg )
{   if(count1 == 1)
    {
	sendOutput( msg.time(), startGame, start ) ;
	count1 = 0;
	return *this ;
    }
	sendOutput( msg.time(), scoreOut, score ) ;
	if(currentBallNum>= totalBallNum)
	{
		sendOutput( msg.time(), totalOut, totalScore ) ;
	    sendOutput( msg.time(), totalW, count-1 ) ;
	}
	return *this ;
}
Players::~Players()
{
	delete dist;
}

