/*******************************************************************
*
*  DESCRIPTION: Atomic Model Players
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carleton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/

#ifndef __PLAYERS_H
#define __PLAYERS_H


#include "atomic.h"     // class Atomic

class Distribution ;
class Players : public Atomic
{
public:
	Players( const string &name = "Players" );					//Default constructor
	~Players();
	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &totalBallNumIn;
	const Port &startMatch;
	Port &scoreOut;
	Port &totalOut;
	Port &totalW;
	Port &startGame;
	int currentBallNum;//current ball number
	long double totalBallNum;//total ball number
	int score;// 0 means a wicket fallen ,1 means scored a run, 4 means a boundary, 6 means a sixer
	int totalScore;
	int count;
	int count1;
	int wicket;
	int start;
	Time roundTime;
	long double temp1;//decides if the batsman score a run
	long double tempS;//decides if the batsman hits a six
	long double tempC;//decides if the bowling team gets a wicket
	long double tempF;//decides if the batsman hits a boundary
	long double temp;
	Distribution * dist;
	Distribution &distribution()
			{return *dist;}
};	// class Players

// ** inline ** //
inline
string Players::className() const
{
	return "Players" ;
}

#endif   //__PLAYERS_H
