/*******************************************************************
*
*  DESCRIPTION: Atomic Model Rdumpire
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carleton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/



#ifndef __RDUMPIRE_H
#define __RDUMPIRE_H


#include <list>
#include "atomic.h"     // class Atomic

// RdUmpire class

class Rdumpire : public Atomic
{
public:
	// Constructor
	Rdumpire( const string &name = "Rdumpire" );

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:

	// input ports
	const Port &start_game;

	// output port
	Port &start_period;

   int Period;
	bool game_started;

  	const Time period_interval;

};	// class RdUmpire

// ** inline ** //
inline
string Rdumpire::className() const
{
	return "Rdumpire";
}

#endif   //__RDUMPIRE_H
