/*******************************************************************
*
*  DESCRIPTION: Atomic Model Rdumpire
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carleton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/


/** include files **/
#include "rdumpire.h"// class definition for Rdumpire
#include "message.h"    // class ExternalMessage, InternalMessage

/** public functions **/

/*******************************************************************
* Function Name: Rdumpire constructor
* Description: This routine constructs the Rdumpire model
********************************************************************/
Rdumpire::Rdumpire( const string &name )
: Atomic( name )
, start_game( addInputPort( "start_game" ) )
, start_period( addOutputPort( "start_period" ) )
, period_interval( 0, 45 )
{
}

/*******************************************************************
* Function Name: Rdumpire init function
* Description: This routine is invoked when the simulator starts.  It
* initializes some variables and does nothing else.  The model does not
* begin doing any useful work until "start" is received.
********************************************************************/
Model &Rdumpire::initFunction()
{
	Period = 1;
	game_started = false;

	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This routine handles external events coming from the
* input port.  The start_game signal can only be given once; afterward it
* is ignored.
********************************************************************/
Model &Rdumpire::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == start_game )
   {
		// can only start a game once!
      if (game_started == false)
      {
      	game_started = true;
			holdIn( passive, Time::Zero );
      }
   }

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: The internal function increments the period count and
*              sets the timer interval for the next period.
********************************************************************/
Model &Rdumpire::internalFunction( const InternalMessage & )
{

		// schedule another call to output function when the next period starts
   	if (Period++ < 3)
      {
		   holdIn( passive, period_interval);
      }


	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: This routine outputs <start_period>
********************************************************************/
Model &Rdumpire::outputFunction( const InternalMessage &msg )
{
   if (Period >= 2)
	{
      passivate();
   }
	else
   {
      sendOutput( msg.time(), start_period, Period ) ;
   }

	return *this ;
}
