

#ifndef __Score_H
/*******************************************************************
*
*  DESCRIPTION: Atomic Model Score
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carleton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/
#define __Score_H

//#include <list>
#include "atomic.h"     // class Atomic

class Score : public Atomic
{
public:
	Score( const string &name = "Score" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &totalScoreIn;
	const Port &totalWicketIn;
	Port &totalScoreOut;
	Port &totalWicketOut;

	int finalScore;
	int wicket;


};	// class Score

// ** inline ** //
inline
string Score::className() const
{
	return "Score" ;
}

#endif   //__Score_H
