/*******************************************************************
*
*  DESCRIPTION: Atomic Model TicketWindow
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carelton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/

#ifndef __TICKETWINDOW_H
#define __TICKETWINDOW_H


#include "atomic.h"     // class Atomic

class TicketWindow : public Atomic
{
public:
	TicketWindow( const string &name = "TicketWindow" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &audienceIn;
	Port &moneyOut;
	Port &audienceOut;

	Time timeForAudience;
	int currentQueue1Num; 	//the current queue1 length for audience
	int totalQueue1Num;		//total audienceIn number, if the accumulated audience number is equal or //larger than 500, the TicketWindow will not work at all because audience seats are full!
	int money; 				//money =5*audience number



};	// class TicketWindow

// ** inline ** // 
inline
string TicketWindow::className() const
{
	return "TicketWindow" ;
}

#endif   //__TicketWindow_H
