#ifndef BOOST_SIMULATION_PDEVS_BM_FILTER_H 
#define BOOST_SIMULATION_PDEVS_BM_FILTER_H

#include <string>
#include <iostream>
#include <vector>
#include <assert.h>
#include <boost/simulation/pdevs/atomic.hpp>
#include "types.hpp"
#include "britime.hpp"
#include <random>

using namespace boost::simulation::pdevs;
using namespace boost::simulation;
using namespace std;

class filter : public pdevs::atomic<BRITime, Message_t> {

private:

    string               _ID;
    BRITime              _ta;
    vector <Message_t>   _msg;
    BRITime              INF;          
    BRITime              INSTANTANEOUS;
        
public:
   
    explicit filter (string id) noexcept {

        INF            = numeric_limits<BRITime>::infinity();
        INSTANTANEOUS  = BRITime(1, 100000);
        _ID              = id;
        _ta              = INF;              

     }

    void internal() noexcept {

         _msg.clear();  
         _ta = INF; 
        
     }
   
    BRITime advance() const noexcept {
        
        return _ta; 
    }
   
    vector<Message_t> out() const noexcept { 
        
      return _msg;
    }
        
    void external(const vector<Message_t>& mb, const BRITime& t) noexcept { 

      _msg.clear();
      
      for (int i = 0; i<mb.size(); i++){
        
        for (int j = 0; j < mb[i].to.size(); j++){

          if (mb[i].to[j] == _ID){

            _msg.push_back(mb[i]);
          }
        }
      }
      if (_msg.empty()){

        _ta = INF;

      }else {

        _ta = INSTANTANEOUS;

        }   
    }
         
    void confluence(const vector<Message_t>& mb, const BRITime& t)  noexcept  { 
        _msg.clear();
         external(mb, t);
     }

};

#endif // BOOST_SIMULATION_PDEVS_BM_FILTER_H
