#ifndef BOOST_SIMULATION_PDEVS_BM_CAR_TL_H 
#define BOOST_SIMULATION_PDEVS_BM_CAR_TL_H

#include <string>
#include <vector>
#include <assert.h>
#include <boost/simulation/pdevs/atomic.hpp>
#include "britime.hpp"
#include "types.hpp"

using namespace boost::simulation::pdevs;
using namespace boost::simulation;
using namespace std;



class car_traffic_ligth : public pdevs::atomic<BRITime, Message_t> {

private:

    string      _ID;
    BRITime     _ta;
    BRITime     _in_yellow_car;
    BRITime     _in_yellow_pedestrian;
    BRITime     _delay_to_green;
    string      _state;
    string      _next_state;
    bool        _sending;
    BRITime     INF;
    BRITime     INSTANTANEOUS; 
    
public:
   
    explicit car_traffic_ligth (string id, BRITime in_yellow_car, BRITime in_yellow_pedestrian, BRITime delay_to_green) noexcept {

        INF                   = numeric_limits<BRITime>::infinity();
        INSTANTANEOUS         = BRITime(1, 100000); 
        _ID                   = id;
        _ta                   = INF;        
        _in_yellow_car        = in_yellow_car;
        _in_yellow_pedestrian = in_yellow_pedestrian;
        _delay_to_green       = delay_to_green;
        _state                = string("red");
        _next_state           = string("no_next_state");
        
     }

    void internal() noexcept {

        _state = _next_state;
        if ( (_next_state == string("green")) |  (_next_state == string("red"))){
            _next_state = string("no_next_state");
            _ta = INF;
        } else if (_next_state == string("yellow")){
            _next_state = string("red");
            _ta = _in_yellow_car;
        }
     }
   
    BRITime advance() const noexcept {

        return _ta; 
    }
   
    vector<Message_t> out() const noexcept { 

        vector<Message_t> output;
        Message_t msg;
        msg.from = _ID;
        msg.to.push_back(string("model_output"));
        msg.information = _next_state;
        output.push_back(msg);
        return output;      
         
    }
        
    void external(const vector<Message_t>& mb, const BRITime& t) noexcept { 

        if (_state != mb[0].information){
            if ( mb[0].information == string("green")){
            _next_state = string("green");
            _ta = _in_yellow_car + _in_yellow_pedestrian + _delay_to_green;
            } else if ( mb[0].information == string("red")){
                _next_state = string("yellow");
                _ta = _in_yellow_pedestrian;
             }
        }

    }


         
    void confluence(const vector<Message_t>& mb, const BRITime& t)  noexcept  { 
       assert(false && "The definition of the model only allows reciving an instruction to change the state when it is stable in red or green");

     }

};

#endif // BOOST_SIMULATION_PDEVS_BM_CAR_TL_H
