#include <iostream>
#include <fstream>
#include <string>
#include <chrono>
#include <algorithm>
#include <limits>
#include "britime.hpp"
#include "types.hpp"
#include <boost/algorithm/string.hpp>
#include <boost/simulation.hpp>
#include <boost/simulation/pdevs/basic_models/generator.hpp>
#include "traffic_controller.hpp"
#include "crossed_cars.hpp"
#include "filter.hpp"
#include "pedestrian_button.hpp"
#include "car_line.hpp"
#include "car_traffic_ligth.hpp" 
#include "pedestrian_traffic_ligth.hpp"
#include "trafic_light_coordinator.hpp"

using namespace std;
using namespace boost::simulation;
using namespace boost::simulation::pdevs;
using namespace boost::simulation::pdevs::basic_models;

using hclock = chrono::high_resolution_clock;
using Time = BRITime;
using Message = Message_t;


int main(){

    BRITime     cicle_time;
    BRITime     in_yellow_car;
    BRITime     in_yellow_pedestrian;
    BRITime     delay_to_green;
    BRITime     time_to_cross;
    BRITime     running_simulation_untill;
    string      test_file;
    int a;

    cout << "entre cycle time of the controller" << endl;
    cin >> a;
    cicle_time = BRITime(a);
    cout << "entre time in yellow for cars" << endl;
    cin >> a;
    in_yellow_car = BRITime(a);;
    cout << "entre time in yellow for pedestrians" << endl;
    cin >> a;
    in_yellow_pedestrian = BRITime(a);;
    cout << "entre the delay to green of the semaphore" << endl;
    cin >> a;
    delay_to_green = BRITime(a);;
    cout << "entre the time a car takes to cross the crossroad" << endl;
    cin >> a;
    time_to_cross = BRITime(a);;
    cout << "entre time untill you want to run the simulation" << endl;
    cin >> a;
    running_simulation_untill = BRITime(a);;
    cout << "enter the name of the test file where the input is stored (ex:test_1.txt)" << endl;
    cin >> test_file;
    
    if ((cicle_time <= (in_yellow_car + in_yellow_pedestrian + delay_to_green))){
        assert(false && "cycle time has to be greater than the sum of time in yellow for cars plus time in yellow for pedestrians plus delay to green of the semaphore");
    }

    cout << "Creating Crossroad top model" << endl;

    ifstream file(test_file);
    string str;
    string file_contents;
    while (getline(file, str))
        {
            file_contents += str;
            file_contents.push_back('\n');
        }  
    string m_input;
    m_input = file_contents;

    cout << "model input:" << endl;
    cout << m_input << endl;

    shared_ptr<istringstream> piss1{ new istringstream{} };
    piss1->str(m_input);
    
    auto pf_1 = make_atomic_ptr<input_stream<BRITime, Message_t, BRITime, Message_t>, shared_ptr<istringstream>, BRITime>(piss1, BRITime(0),
                [](const string& s, BRITime& t_next, Message_t& m_next)->void{ //parsing function
            
            string aux;
            vector<string> tokens;

            istringstream ss;
            ss.str(s);
            ss >> t_next;
            
            aux.clear();
            ss >> aux;
            aux.pop_back();
            aux.erase(aux.begin());
            tokens.clear();          
            boost::split(tokens, aux, boost::is_any_of(","));

            m_next.to.clear();

            for (int i = 0; i<tokens.size(); i++){
                
                m_next.to.push_back(tokens[i]);
            }

            ss >> m_next.from;
            ss >> m_next.amount;
                        
            string thrash;
            ss >> thrash;
            if ( 0 != thrash.size()) throw exception();
        });
   
    auto tc = make_atomic_ptr<traffic_controller, string>(string("TC"), cicle_time); 
    auto filter_tc = make_atomic_ptr<filter, string>(string("TC"));
    auto cc1 = make_atomic_ptr<crossed_cars, string, BRITime, string, vector<string>, BRITime, BRITime, BRITime>(string("CC1"),  time_to_cross, string("CTL1"), vector<string> {string("LL1"), string("RL1")}, in_yellow_car, in_yellow_pedestrian, delay_to_green);
    auto cc2 = make_atomic_ptr<crossed_cars, string, BRITime, string, vector<string>, BRITime, BRITime, BRITime>(string("CC2"),  time_to_cross, string("CTL2"), vector<string> {string("LL2"), string("RL2")}, in_yellow_car, in_yellow_pedestrian, delay_to_green);
    auto filter_cc1 = make_atomic_ptr<filter, string>(string("CC1"));
    auto filter_cc2 = make_atomic_ptr<filter, string>(string("CC2"));
    auto filter_pb1 = make_atomic_ptr<filter, string>(string("PB1")); 
    auto pb1 = make_atomic_ptr<pedestrian_button, string>(string("PB1")); 
    auto filter_pb2 = make_atomic_ptr<filter, string>(string("PB2")); 
    auto pb2 = make_atomic_ptr<pedestrian_button, string>(string("PB2")); 
    auto filter_ll1 = make_atomic_ptr<filter, string>(string("LL1")); 
    auto filter_rl1 = make_atomic_ptr<filter, string>(string("RL1")); 
    auto car_line_ll1 = make_atomic_ptr<car_line, string>(string("LL1")); 
    auto car_line_rl1 = make_atomic_ptr<car_line, string>(string("RL1")); 
    auto filter_ll2 = make_atomic_ptr<filter, string>(string("LL2")); 
    auto filter_rl2 = make_atomic_ptr<filter, string>(string("RL2")); 
    auto car_line_ll2 = make_atomic_ptr<car_line, string>(string("LL2")); 
    auto car_line_rl2 = make_atomic_ptr<car_line, string>(string("RL2")); 
    auto tlco = make_atomic_ptr<coordinator_traffic_ligth, string>(string("TLCo"));
    auto filter_tlco = make_atomic_ptr<filter, string>(string("TLCo"));
    auto ctl_1 = make_atomic_ptr<car_traffic_ligth, string, BRITime, BRITime, BRITime>(string("CTL1"),in_yellow_car, in_yellow_pedestrian, delay_to_green); 
    auto ptl_1 = make_atomic_ptr<pedestrian_traffic_ligth, string, BRITime, BRITime, BRITime>(string("PTL1"),in_yellow_car, in_yellow_pedestrian, delay_to_green); 
    auto filter_ctl1 = make_atomic_ptr<filter, string>(string("CTL1"));
    auto filter_ptl1 = make_atomic_ptr<filter, string>(string("PTL1"));
    auto ctl_2 = make_atomic_ptr<car_traffic_ligth, string, BRITime, BRITime, BRITime>(string("CTL2"),in_yellow_car, in_yellow_pedestrian, delay_to_green); 
    auto ptl_2 = make_atomic_ptr<pedestrian_traffic_ligth, string, BRITime, BRITime, BRITime>(string("PTL2"),in_yellow_car, in_yellow_pedestrian, delay_to_green); 
    auto filter_ctl2 = make_atomic_ptr<filter, string>(string("CTL2"));
    auto filter_ptl2 = make_atomic_ptr<filter, string>(string("PTL2"));
    
    shared_ptr<flattened_coupled<Time, Message>> ll1_coupled(new flattened_coupled<Time, Message>(
    {filter_ll1, car_line_ll1}, 
    {filter_ll1}, 
    {{filter_ll1, car_line_ll1}}, 
    {car_line_ll1}
    ));    
    shared_ptr<flattened_coupled<Time, Message>> rl1_coupled(new flattened_coupled<Time, Message>(
    {filter_rl1, car_line_rl1}, 
    {filter_rl1}, 
    {{filter_rl1, car_line_rl1}}, 
    {car_line_rl1}
    ));   
    shared_ptr<flattened_coupled<Time, Message>> car_line_1_coupled(new flattened_coupled<Time, Message>(
    {ll1_coupled, rl1_coupled}, 
    {ll1_coupled, rl1_coupled}, 
    {}, 
    {ll1_coupled,rl1_coupled}
    ));
    shared_ptr<flattened_coupled<Time, Message>> ll2_coupled(new flattened_coupled<Time, Message>(
    {filter_ll2, car_line_ll2},  
    {filter_ll2}, 
    {{filter_ll2, car_line_ll2}}, 
    {car_line_ll2}
    ));
    shared_ptr<flattened_coupled<Time, Message>> rl2_coupled(new flattened_coupled<Time, Message>(
    {filter_rl2, car_line_rl2},  
    {filter_rl2}, 
    {{filter_rl2, car_line_rl2}}, 
    {car_line_rl2}
    ));
    shared_ptr<flattened_coupled<Time, Message>> car_line_2_coupled(new flattened_coupled<Time, Message>(
    {ll2_coupled, rl2_coupled},  
    {ll2_coupled, rl2_coupled}, 
    {}, 
    {ll2_coupled,rl2_coupled}
    ));
      
    shared_ptr<flattened_coupled<Time, Message>> pb1_coupled(new flattened_coupled<Time, Message>(
    {filter_pb1, pb1},  
    {filter_pb1}, 
    {{filter_pb1, pb1}}, 
    {pb1}
    ));
    shared_ptr<flattened_coupled<Time, Message>> pb2_coupled(new flattened_coupled<Time, Message>(
    {filter_pb2, pb2},  
    {filter_pb2}, 
    {{filter_pb2, pb2}}, 
    {pb2}
    ));
    shared_ptr<flattened_coupled<Time, Message>> tc_coupled(new flattened_coupled<Time, Message>(
    {filter_tc, tc},  
    {filter_tc}, 
    {{filter_tc, tc}}, 
    {tc}
    ));
    shared_ptr<flattened_coupled<Time, Message>> cc1_coupled(new flattened_coupled<Time, Message>(
    {filter_cc1, cc1},  
    {filter_cc1}, 
    {{filter_cc1, cc1}}, 
    {cc1}
    ));
    shared_ptr<flattened_coupled<Time, Message>> cc2_coupled(new flattened_coupled<Time, Message>(
    {filter_cc2, cc2},  
    {filter_cc2}, 
    {{filter_cc2, cc2}}, 
    {cc2}
    ));
    shared_ptr<flattened_coupled<Time, Message>> crossroad_controller_coupled(new flattened_coupled<Time, Message>(
    {tc_coupled,cc1_coupled,cc2_coupled},  
    {tc_coupled}, 
    {{tc_coupled, cc1_coupled},{tc_coupled,cc2_coupled}}, 
    {tc_coupled,cc1_coupled, cc2_coupled}
    ));
    shared_ptr<flattened_coupled<Time, Message>> tlco_coupled(new flattened_coupled<Time, Message>(
    {filter_tlco, tlco},  
    {filter_tlco}, 
    {{filter_tlco, tlco}}, 
    {tlco}
    ));
    shared_ptr<flattened_coupled<Time, Message>> ctl_1_coupled(new flattened_coupled<Time, Message>(
    {filter_ctl1, ctl_1},  
    {filter_ctl1}, 
    {{filter_ctl1, ctl_1}}, 
    {ctl_1}
    ));
    shared_ptr<flattened_coupled<Time, Message>> ptl_1_coupled(new flattened_coupled<Time, Message>(
    {filter_ptl1, ptl_1},  
    {filter_ptl1}, 
    {{filter_ptl1, ptl_1}}, 
    {ptl_1}
    ));
    shared_ptr<flattened_coupled<Time, Message>> tl_1_coupled(new flattened_coupled<Time, Message>(
    {ptl_1_coupled, ctl_1_coupled},  
    {ptl_1_coupled, ctl_1_coupled}, 
    {}, 
    {ptl_1_coupled, ctl_1_coupled}
    ));
    shared_ptr<flattened_coupled<Time, Message>> ctl_2_coupled(new flattened_coupled<Time, Message>(
    {filter_ctl2, ctl_2},  
    {filter_ctl2}, 
    {{filter_ctl2, ctl_2}}, 
    {ctl_2}
    ));
    shared_ptr<flattened_coupled<Time, Message>> ptl_2_coupled(new flattened_coupled<Time, Message>(
    {filter_ptl2, ptl_2},  
    {filter_ptl2}, 
    {{filter_ptl2, ptl_2}}, 
    {ptl_2}
    ));
    shared_ptr<flattened_coupled<Time, Message>> tl_2_coupled(new flattened_coupled<Time, Message>(
    {ptl_2_coupled, ctl_2_coupled},  
    {ptl_2_coupled, ctl_2_coupled}, 
    {}, 
    {ptl_2_coupled, ctl_2_coupled}
    ));
    shared_ptr<flattened_coupled<Time, Message>> crossroad_tl_coupled(new flattened_coupled<Time, Message>(
    {tl_1_coupled, tl_2_coupled, tlco_coupled},  
    {tlco_coupled}, 
    {{tlco_coupled, tl_1_coupled}, {tlco_coupled, tl_2_coupled}}, 
    {tl_1_coupled, tl_2_coupled}
    ));
    shared_ptr<flattened_coupled<Time, Message>> crossroad_top_model(new flattened_coupled<Time, Message>(
    {crossroad_controller_coupled, pb1_coupled, pb2_coupled, car_line_2_coupled, car_line_1_coupled, crossroad_tl_coupled},  
    {pb2_coupled, pb1_coupled, car_line_2_coupled,car_line_1_coupled}, 
    {{pb1_coupled, crossroad_controller_coupled},{pb2_coupled, crossroad_controller_coupled}, {crossroad_controller_coupled, pb1_coupled}, {crossroad_controller_coupled, pb2_coupled}, {crossroad_controller_coupled, car_line_1_coupled}, {crossroad_controller_coupled, car_line_2_coupled},{crossroad_controller_coupled, crossroad_tl_coupled}}, 
    {pb1_coupled, pb2_coupled, car_line_1_coupled, car_line_2_coupled, crossroad_tl_coupled}
    ));
    shared_ptr<flattened_coupled<Time, Message>> crossroad_top_model_with_input(new flattened_coupled<Time, Message>(
    {pf_1, crossroad_top_model},  
    {}, 
    {{pf_1, crossroad_top_model}}, 
    {crossroad_top_model}
    ));  

    cout << "Preparing runner" << endl;
    Time initial_time = BRITime(0); 
    ofstream out_data("output.txt");   
    runner<Time, Message> r(crossroad_top_model_with_input, initial_time, out_data, [](ostream& os, Message m){ os << m;});
    Time end_time = running_simulation_untill;

    cout << "Starting simulation until time: " << end_time << "seconds" << endl;

    auto start = hclock::now(); 
    end_time = r.runUntil(end_time); 
    auto elapsed = chrono::duration_cast<std::chrono::duration<double, std::ratio<1>>> (hclock::now() - start).count();
    
    cout << "Finished simulation with time: " << end_time << "sec" << endl;
    cout << "Simulation took: " << elapsed << "sec" << endl;
    return 0;
}  
