#ifndef BOOST_SIMULATION_TYPES_H
#define BOOST_SIMULATION_TYPES_H

#include <iostream>
#include <string>
#include <list>
#include <vector>
#include <map>
#include "britime.hpp"


using namespace std;

/*******************************************/
/**************** Message_t ****************/
/*******************************************/


struct Message_t {
  
  public:

  vector <string> to;
  string from;
  string information;
  int amount;
  BRITime timer;

  
 
  Message_t()
  :to(), from(""), information(""), amount(0), timer(0) {}

  void clear() {
    to.clear();
    from             = "";
    information      = "";
    amount           = 0;
    timer            = BRITime(0);
   


  }
};

ostream& operator<<(ostream& os, const Message_t& msg);

/*******************************************/
/************** End Message_t **************/
/*******************************************/
 



#endif // BOOST_SIMULATION_TYPES_H