/*******************************************************************
*
*  DESCRIPTION: Comptroller
*
*  AUTHOR: Ekambir Sidhu + Manohar Deep Singh Gill
*
*******************************************************************/

/** include header files **/
#include "comptroller.h"  
#include "message.h"   	 
#include "mainsimu.h"

/*******************************************************************
* Function Name: comptroller
********************************************************************/
comptroller::comptroller( const string &name )
: Atomic( name )
, enter_sys( addInputPort( "enter_sys" ) )
, exit_q( addInputPort( "exit_q" ) )
, exit_sys( addInputPort( "exit_sys" ) )
, in( addInputPort( "in" ) )
, epc( addOutputPort( "epc" ) )
, epq( addOutputPort( "epq" ) )
, wtq( addOutputPort( "wtq" ) )
, wtc( addOutputPort( "wtc" ) )
{
//empty	
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model& comptroller::initFunction()
{
	
in_sys = 0;
out_q = 0;
out_sys = 0;
epc_val = 0;
wtq_val = 0;
epq_val = 0;
wtc_val = 0;
arrivalTimesepq.erase( arrivalTimesepq.begin(), arrivalTimesepq.end() );
arrivalTimeswtc.erase( arrivalTimeswtc.begin(), arrivalTimeswtc.end() );

return *this ;
}

/*******************************************************************
* Function Name: externalFunction
********************************************************************/
Model& comptroller::externalFunction( const ExternalMessage &msg )
{

if (msg.port() == enter_sys)
	{
	in_sys++;  
	arrivalTimesepq.push_back(msg.time());
	calculate_epq();
	calculate_epc();
	}
else if (msg.port() == exit_q)
	{
	out_q++;  
	calculate_epq();
	calculate_wtq(msg.time());
	}
else if (msg.port() == exit_sys)
	{
	out_sys++;  
	calculate_epc();
	calculate_wtc(msg.time());
	}
else if (msg.port() == in)
	{
	holdIn( active, Time::Zero);
	}

return *this;
}

/*******************************************************************
* Function Name: internalFunction
********************************************************************/
Model& comptroller::internalFunction( const InternalMessage & )
{
passivate();
return *this ;
}

/*******************************************************************
* Function Name: outputFunction
********************************************************************/
Model &comptroller::outputFunction( const InternalMessage &msg )
{

sendOutput( msg.time(), epc, epc_val);
sendOutput( msg.time(), epq, epq_val);
sendOutput( msg.time(), wtq, wtq_val);
sendOutput( msg.time(), wtc, wtc_val);

return *this;
}
/************************************************
* The mean of elements in the queue
*************************************************/
void comptroller::calculate_epq()
{
int q_update = in_sys + out_q;
int cur_q_size = in_sys - out_q;

epq_val = ((epq_val * q_update) + cur_q_size) / (q_update + 1);
}
/***********************************************
* The mean of elements in system
* *********************************************/
void comptroller::calculate_epc()
{
int sys_update = in_sys + out_sys;
int cur_sys_size = in_sys - out_sys;

epc_val = ((epc_val * sys_update) + cur_sys_size) / (sys_update + 1);
}
/************************************************
* The mean of waiting time in the queue
*************************************************/
void comptroller::calculate_wtq(const Time &cur_time)
{
Time cur_wating_time;
float cur_wating_time_sec;

MASSERT (!arrivalTimesepq.empty());

if (cur_time >= arrivalTimesepq.front() )
	{
	cur_wating_time = cur_time - arrivalTimesepq.front(); 
	cur_wating_time_sec = convertTimeToHrs(cur_wating_time);

	MASSERT(out_q > 0);
	wtq_val = ( (wtq_val * (out_q - 1)) + cur_wating_time_sec ) / out_q;
	}
arrivalTimeswtc.push_back(arrivalTimesepq.front());
arrivalTimesepq.pop_front();
}
/************************************************
* The mean of waiting time in the system
*************************************************/
void comptroller::calculate_wtc(const Time &cur_time)
{
Time cur_wating_time;
float cur_wating_time_sec;

MASSERT (!arrivalTimeswtc.empty());

if (cur_time >= arrivalTimeswtc.front() )
	{
	cur_wating_time = cur_time - arrivalTimeswtc.front(); 
	cur_wating_time_sec = convertTimeToHrs(cur_wating_time);

	MASSERT(out_sys > 0);
	wtc_val = ( (wtc_val * (out_sys - 1)) + cur_wating_time_sec ) / out_sys;
	}
arrivalTimeswtc.pop_front();
}
/************************************************
* Convert time into seconds
*************************************************/
float comptroller::convertTimeToHrs(const Time &time)
{
int hour = time.hours();
int min =(float)time.minutes()/60;
int sec = (float)time.seconds()/3600;
float msec = (float)time.mseconds()/3600000;

return hour + min + sec + msec;
}
