/*******************************************************************
*
*  DESCRIPTION: Healthy Smile Dental Clinic
*
*  AUTHOR: Ekambir Sidhu + Manohar Deep Singh Gill
*
*******************************************************************/

#ifndef __doctor_H
#define __doctor_H

#include "atomic.h"

/** forward declarations **/
class Distribution ;

class doctor : public Atomic
{
public:
	doctor( const string &name = "doctor" );
	~doctor ();

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &rdy;
	Port &out;
	Port &nxtpatcall;
	int myId;  
	double value;
	bool ready;
	Distribution *dist ;

	Distribution &distribution()
			{return *dist;}	
};	

inline
string doctor::className() const
{
	return "doctor" ;
}

#endif 
