/*******************************************************************
*
*  DESCRIPTION: class tokengenerator
*  AUTHOR: Ekambir Sidhu + Manohar Deep Singh  Gill
*
*
*******************************************************************/

/** include header files **/
#include "tokengen.h"       
#include "message.h"        
#include "mainsimu.h"     
#include "distri.h"         
#include "strutil.h"       

/*******************************************************************
* Function Name: tokengenerator* Description: constructor
********************************************************************/
tokengenerator::tokengenerator( const string &name )
: Atomic( name )
, out( addOutputPort( "out" ) )
{
try
{
dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );
MASSERT( dist ) ;
for ( register int i = 0; i < dist->varCount(); i++ )
	{
	string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar( i ) ) ) ;
	dist->setVar( i, str2Value( parameter ) ) ;
	}

} catch( InvalidDistribution &e )
	{
	e.addText( "The model " + description() + " has distribution problems!" ) ;
	e.print(cerr);
	MTHROW( e ) ;
} catch( MException &e )
	{
	MTHROW( e ) ;
	}
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &tokengenerator::initFunction()
{
patient_id = 0;
patients = 0;
holdIn( active, Time::Zero);

return *this;
}

/*******************************************************************
* Function Name: internalFunction
********************************************************************/
Model &tokengenerator::internalFunction( const InternalMessage & )
{
static double all_patients;

if (patients == 0)
	{
	patients = fabs( distribution().get() );  
	all_patients = patients;
	}

if (patients > 0)
	holdIn( active, Time(0,0,0,3600000/all_patients) );
else
	holdIn( active, Time(0,0,1,0) );

return *this ;
}

/*******************************************************************
* Function Name: outputFunction
********************************************************************/
Model &tokengenerator::outputFunction( const InternalMessage &msg )
{

if (patients > 0)
	{
	patient_id++;
	sendOutput( msg.time(), out, patient_id);
	patients--;
	}

return *this ;
}
/*******************************************************************
* Function Name:
********************************************************************/
tokengenerator::~tokengenerator()
{
delete dist;
}