// Author: Omar Hesham, March 2016. 
//         Based on 2011 VoroDyn demos.
//         See omarhesham.com for more details.
//
//__________________________________________________________________
// Modified for SYSC5104 Project [December 2017] by:
//                -Shashi Bhushan
//    In this file, only the crowd count is changed
//    Modifications(mainly under Mods.pde file     
//      -Added functionality for flocking
//        -Three steering forces are calculated namely, CohesionForce, separationForce and AlignmnetForce
//        -All the three forces can be disabled and re-enabled in runtime by pressing relevant keys: Cntrl for cohesionForce, Shift for separationForce and Alt for alignmentForce
//
//    * All the modifications for flocking can be searched by searcing the keyword "ModFlocking"
//___________________________________________________________________
// Modified for SYSC5104 Project [December 2016] by: 
//              - Princy (last name?)
//              - Walter Aburime
//   Modifications (found mainly under the Mods.pde file):
//     - Group Gathering (meeting friends/family)
//     - Group motion with/against crowd flow (family/vip staying together)
//     - Uncooperative Behaviour (slowing traffic, creating bottlenecks, etc.)
//     - Custom Obstacle Maps (through PNG images)
// 

PShader bwShader;
int[] specialEntityIDs;

void setupScene(){
  SNAPVAL = 0.5;
  ENTITY_ID = 0;
  CONIC_RES = 12 ;
  lastFrameTime=0;
  FPS_DISPLAY_MAX = 500;
  FPS_COMPUTE_MAX = 500;
  FRAME_TIME = 1/FPS_COMPUTE_MAX;
  COLOR_ID_STEP = 4;
  CROWDCOUNT = 1; //ModFlocking.. Used 10 special entities
  SUBPIXELS = 1;
  CONE_RADIUS = 8 * SUBPIXELS;
  CONE_DEPTH = 100;
  FORCE_GRAVITY = 0; 
  SCREEN_FILL = true;
  DEBUG = false;
  DISPLAY_PRESSURE = !!DISPLAY_PRESSURE; // don't reset every 'R', it's annoying :)
  DISPLAY_OBJECTIVE = !!DISPLAY_OBJECTIVE;
  PRINT_FRAMERATE = !false;
  MOUSE_DETRACT = 4;
  PAUSE_SIGNAL = false;
  INITIAL_DISTRIBUTION = NONSPECIAL_INIT_DISTRIBUTION;

  noStroke(); 
  if(START_PAUSED) noLoop(); 
  //noSmooth();

  bwShader = loadShader("threshold.glsl");
  bwShader.set("CROWDCOUNT", CROWDCOUNT);

  frameRate(FPS_COMPUTE_MAX);
  initializeGlobalShapesBank();
  // 0. Set up Canvas and top view camera
  canvas = new Canvas(createGraphics(int(SUBPIXELS*WIDTH), int(SUBPIXELS*HEIGHT), P3D), new RenderView());
  canvas.getPGraphics().noSmooth();
  // 1. Set Entity intial positions and shapes
  crowd = new EntitySystem(new PVector(), CROWDCOUNT);
  crowd.initializePositions(INITIAL_DISTRIBUTION);
  
  // [MOD] Modification Initializations
  modification_Initialization();

  // Greeting UI
  println("Controls:");
  println("\tSpace: pause/unpause simulation");
  println("\tR: reset the scene");
  println("\tA: toggle pressure display");
  println("\tF: print framerate every 10 frames");
  println("\tUp/Down: control spring stability threshold");
  println("\tLeft/Right: control conic shape resolution");
}

float clamp(float val, float min, float max){return constrain(val,min,max);}
float snap(float val, float threshold, float snapTo){return abs(val)<threshold?snapTo:val;}
float snapDecay(float val, float threshold){return abs(val)<threshold?abs(val)*val/threshold:val;}
float safeDivisionByZero(float num, float denom){return denom==0?0:num/denom;}
int   safeDivisionByZero(int num, int denom){return denom==0?0:num/denom;}
color ID_TO_COLOR(int id){ return id>=0? 0xFF00000A+(id*COLOR_ID_STEP): color(0,0,id+10);}
int COLOR_TO_ID(color colorCode){ //reserved obstacles color : regular entity color
  return (colorCode<color(0,0,11)) ? (int)blue(colorCode)-10 : (colorCode-0xFF00000A)/COLOR_ID_STEP; 
}
void settings() {
  size(WIDTH, HEIGHT, P2D);
}

void setup() {
  setupScene();
}

void draw() { 
  PGraphics ds = canvas.getPGraphics();

  // 1. Draw the scene
  canvas.setupView().drawEntitySystem(crowd).drawObstacles().wrapUpView(); 
  
  // 2. Compute centroidal dynamics
  modification_Update(); // [MOD] Update global vars
  canvas.beginDraw().calcEntitySystemCentroids(crowd);
  modification_Forces(); // [MOD] Special entity forces
  canvas.endDraw();

  // 3. Visualize the results
  if (frameRate <= FPS_DISPLAY_MAX || millis()-lastFrameTime>=1000/FPS_DISPLAY_MAX) {
    resetShader();
    if (DISPLAY_PRESSURE) {
      canvas.setupPressureShader(); shader(bwShader); 
    }
    image(ds, 0, 0, SCREEN_FILL?width:ds.width, SCREEN_FILL?height:ds.height);
    
    // [MOD] Visualize special entities
    modification_Visualization();
  }
  
  // Compute timing for fps counter
  lastFrameTime = millis();
  FRAME_TIME = 1/frameRate; // frame time in seconds
  surface.setTitle("Framerate: " + int(frameRate) +"fps");
}

int SELECTED_PARTICLE = -1;
void mousePressed(){
  if(looping)
    SELECTED_PARTICLE = COLOR_TO_ID(canvas.getPGraphics().get(mouseX, mouseY));
}

void mouseDragged(){
  if (looping && SELECTED_PARTICLE < CROWDCOUNT && SELECTED_PARTICLE >= 0){
    Entity entity = crowd.getEntities()[SELECTED_PARTICLE];
    entity.getPosition().x = pmouseX/SUBPIXELS;
    entity.getPosition().y = pmouseY/SUBPIXELS;
    entity.setVelocity(new PVector(mouseX-pmouseX, mouseY-pmouseY));
  }
}

void mouseReleased(){  
  if(looping)
    SELECTED_PARTICLE = -1;
}

void mouseDown(){
  if (looping && SELECTED_PARTICLE < CROWDCOUNT && SELECTED_PARTICLE >= 0){
    Entity entity = crowd.getEntities()[SELECTED_PARTICLE];
    entity.getPosition().x = pmouseX/SUBPIXELS;entity.getPosition().y = pmouseY/SUBPIXELS;
    entity.setVelocity(new PVector(mouseX-pmouseX, mouseY-pmouseY));
  }
}