/*******************************************************************
*  DESCRIPTION: Atomic Model sort
*  AUTHOR: Emad Khan
*  EMAIL: emadkhan@cmail.carleton.ca
*  DATE: 30/10/2016
*******************************************************************/
#ifndef __SORT_H
#define __SORT_H

#include <list>
#include "atomic.h"     // class Atomic

class sort : public Atomic
{
public:
	sort( const string &name = "sorting" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
   const Port &order ;
   const Port &reqorder ;
   Port &packorder ;
   Port &ready ;
   Time prepTime;
   int cltcount; //Number of Clients
   int cltmax;
   int newcltmax;
   Time timeLeft;

};	// class sort

// ** inline ** //
inline
string sort::className() const
{
	return "sort" ;
}

#endif   //__sort_H
