/*******************************************************************
*  DESCRIPTION: Atomic Model Sort
*  AUTHOR: Emad Khan
*  EMAIL: emadkhan@cmail.carleton.ca
*  DATE: 30/10/2016
*******************************************************************/

/** include files **/
#include "pack.h"      // class pack
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name: pack
********************************************************************/
pack::pack( const string &name )
: Atomic( name )
, packorder( addInputPort( "packorder" ) ) //Represent Input of Pack Order coming from Sort
, reqorder( addOutputPort( "reqorder" ) ) //Represent Output to Request Order from Sort
, prepTime( 0, 0, 10, 0 ) //Preparation Time = 10 mins
{
   string time( MainSimulator::Instance().getParameter( description(), "prepTime" ) ) ;

   if( time != "" )
		prepTime = time ;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &pack::initFunction()
{
   passivate(); //Initially, passivate
   return *this ;
}

/*******************************************************************
* Function Name: externalFunction
********************************************************************/
Model &pack::externalFunction( const ExternalMessage &msg )
{
   if(state() == active){}

   else
   {
	   holdIn(active, prepTime );
   }
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
********************************************************************/
Model &pack::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
********************************************************************/
Model &pack::outputFunction( const InternalMessage &msg )
{
   sendOutput( msg.time(), reqorder, 1 ) ;
	return *this ;
}
