[top]
components : isisRobot

[isisRobot]
type : cell
dim : (10,10,2)
delay : transport
defaultDelayTime : 100
border : nowrapped  
%Extended Von Neumann neighbourhood.
% Layer 0 - Location of robots and the map of the ground that they generate (100 = robot; 0 = no bomb; 10 = bomb).
neighbors : isisRobot(-1,0,0) isisRobot(-1,1,0) isisRobot(-2,0,0) isisRobot(0,1,0) isisRobot(1,1,0) isisRobot(0,2,0) isisRobot(1,0,0) isisRobot(1,-1,0) isisRobot(2,0,0) isisRobot(0,-1,0) isisRobot(-1,-1,0) isisRobot(0,-2,0) isisRobot(0,0,0)
% Layer 1 - Actual disposition of bombs (30 = no bomb; 40 = bomb).
neighbors : isisRobot(-1,0,1) isisRobot(-1,1,1) isisRobot(-2,0,1) isisRobot(0,1,1) isisRobot(1,1,1) isisRobot(0,2,1) isisRobot(1,0,1) isisRobot(1,-1,1) isisRobot(2,0,1) isisRobot(0,-1,1) isisRobot(-1,-1,1) isisRobot(0,-2,1) isisRobot(0,0,1)
initialvalue : 0
initialCellsValue : isisFootballGround.val
localtransition : isisRobot10-rule 
zone : ULcorner-rule { (0,0,0)..(0,0,1) }
zone : URcorner-rule { (0,9,0)..(0,9,1) }
zone : BLcorner-rule { (9,0,0)..(9,0,1) }
zone : BRcorner-rule { (9,9,0)..(9,9,1) }
zone : top-rule { (0,1,0)..(0,8,0) (0,1,1)..(0,8,1) }
zone : bottom-rule { (9,1,0)..(9,8,0) (9,1,1)..(9,8,1) }
zone : left-rule { (1,0,0)..(8,0,0) (1,0,1)..(8,0,1) }
zone : right-rule { (1,9,0)..(8,9,0) (1,9,1)..(8,9,1) }

[isisRobot10-rule]
%PART 1 - CELLS WITH NO ROBOTS.
rule : {(0,0,0)} 0 {(0,0,0) = 30 or (0,0,0) = 40}
%PART 2 - SCAN THE GROUND AND MAP IF NOT ALREADY DONE.  
%IF ALREADY SCANNED AND MAPPED, JUST MOVE.
%IF CONFLICT WITH OTHER ROBOT, MOVE AWAY.
%Direction selection.
rule : { round(uniform(201,204))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
rule : { round(uniform(211,214))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
rule : { round(uniform(201,204))} 200 {(0,0,0) = 100}
rule : { round(uniform(211,214))} 200 {(0,0,0) = 110}
%Resolution of conflicts with other robots.
rule : {(0,0,0) + 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,2,0) = 204 or (0,2,0) = 214) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20)}
rule : {(0,0,0) - 3} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-2,0) = 202 or (0,-2,0) = 212) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((2,0,0) = 201 or (2,0,0) = 211) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20)}
rule : {(0,0,0) + 1} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-2,0,0) = 203 or (-2,0,0) = 213) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((1,1,0) = 201 or (1,1,0) = 211) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20)}
rule : {(0,0,0) + 1} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,-1,0) = 202 or (-1,-1,0) = 212) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((-1,1,0) = 203 or (-1,1,0) = 213) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}
rule : {(0,0,0) - 2} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,-1,0) = 202 or (1,-1,0) = 212) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) - 2} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,1,0) = 204 or (1,1,0) = 214) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20)}
rule : {(0,0,0) - 2} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((-1,-1,0) = 203 or (-1,-1,0) = 213) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 3} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,1,0) = 204 or (-1,1,0) = 214) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}
rule : {(0,0,0) - 3} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((1,-1,0) = 201 or (1,-1,0) = 211) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 201 or (1,0,0) = 211)}
rule : {(0,0,0) + 1} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 203 or (-1,0,0) = 213)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 204 or (0,1,0) = 214)}
rule : {(0,0,0) - 1} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 202 or (0,-1,0) = 212)}
%PART 3 - MOVING
%Move.
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((1,0,0) = 201 or (1,0,0) = 211) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20) and ((0,-1,0) != 202 and (0,-1,0) != 212 and (0,1,0) != 204 and (0,1,0) != 214)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,-1,0) = 202 or (0,-1,0) = 212) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20) and ((1,0,0) != 201 and (1,0,0) != 211 and (-1,0,0) != 203 and (-1,0,0) != 213)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((-1,0,0) = 203 or (-1,0,0) = 213) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20) and ((0,-1,0) != 202 and (0,-1,0) != 212 and (0,1,0) != 204 and (0,1,0) != 214)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,1,0) = 204 or (0,1,0) = 214) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20) and ((-1,0,0) != 203 and (-1,0,0) != 213 and (1,0,0) != 201 and (1,0,0) != 211)}
%Clear previous cell
rule : {(0,0,0) - 201} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 20 or (-1,0,0) = 10 or (-1,0,0) = 0) and ((-2,0,0) = 0 or (-2,0,0) = 10 or (-2,0,0) = 20 or (-2,0,0) = ?) and ((-1,-1,0) != 202 and (-1,-1,0) != 212 and (-1,1,0) != 204 and (-1,1,0) != 214)}
rule : {(0,0,0) - 202} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 20 or (0,1,0) = 10 or (0,1,0) = 0) and ((0,2,0) = 0 or (0,2,0) = 10 or (0,2,0) = 20 or (0,2,0) = ?) and ((-1,1,0) != 203 and (-1,1,0) != 213 and (1,1,0) != 201 and (1,1,0) != 211)}
rule : {(0,0,0) - 203} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 20 or (1,0,0) = 10 or (1,0,0) = 0) and ((2,0,0) = 0 or (2,0,0) = 10 or (2,0,0) = 20 or (2,0,0) = ?) and ((1,1,0) != 204 and (1,1,0) != 214 and (1,-1,0) != 202 and (1,-1,0) != 212)}
rule : {(0,0,0) - 204} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 20 or (0,-1,0) = 10 or (0,-1,0) = 0) and ((0,-2,0) = 0 or (0,-2,0) = 10 or (0,-2,0) = 20 or (0,-2,0) = ?) and ((-1,-1,0) != 203 and (-1,-1,0) != 213 and (1,-1,0) != 201 and (1,-1,0) != 211)}
rule : {(0,0,0)} 0 {t}

[ULcorner-rule]
%PART 1 - CELLS WITH NO ROBOTS.
rule : {(0,0,0)} 0 {(0,0,0) = 30 or (0,0,0) = 40}
%PART 2 - SCAN THE GROUND AND MAP IF NOT ALREADY DONE.  
%IF ALREADY SCANNED AND MAPPED, JUST MOVE.
%IF CONFLICT WITH OTHER ROBOT, MOVE AWAY.
%Direction selection.
rule : { if( round(uniform(201,204)) = 201, 202, if( round(uniform(201,204)) = 202, 202, if( round(uniform(201,204)) = 203, 203, if( round(uniform(201,204)) = 204, 203, 203))))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
rule : { if( round(uniform(211,214)) = 211, 212, if( round(uniform(211,214)) = 212, 212, if( round(uniform(211,214)) = 213, 213, if( round(uniform(211,214)) = 214, 213, 213))))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
rule : { if( round(uniform(201,204)) = 201, 202, if( round(uniform(201,204)) = 202, 202, if( round(uniform(201,204)) = 203, 203, if( round(uniform(201,204)) = 204, 203, 203))))} 200 {(0,0,0) = 100}
rule : { if( round(uniform(211,214)) = 211, 212, if( round(uniform(211,214)) = 212, 212, if( round(uniform(211,214)) = 213, 213, if( round(uniform(211,214)) = 214, 213, 213))))} 200 {(0,0,0) = 110}
%rule : { round(uniform(202,203))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
%rule : { round(uniform(212,213))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
%rule : { round(uniform(202,203))} 200 {(0,0,0) = 100}
%rule : { round(uniform(212,213))} 200 {(0,0,0) = 110}
%Resolution of conflicts with other robots.
rule : {(0,0,0) + 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,2,0) = 204 or (0,2,0) = 214) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((2,0,0) = 201 or (2,0,0) = 211) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((1,1,0) = 201 or (1,1,0) = 211) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20)}

rule : {(0,0,0)} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,1,0) = 204 or (1,1,0) = 214) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 201 or (1,0,0) = 211)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 204 or (0,1,0) = 214)}
%PART 3 - MOVING
%Move.
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((1,0,0) = 201 or (1,0,0) = 211) and ((0,1,0) != 204 and (0,1,0) != 214)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,1,0) = 204 or (0,1,0) = 214) and ((1,0,0) != 201 and (1,0,0) != 211)}
%Clear previous cell
rule : {(0,0,0) - 202} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 20 or (0,1,0) = 10 or (0,1,0) = 0) and ((0,2,0) = 0 or (0,2,0) = 10 or (0,2,0) = 20) and ((1,1,0) != 201 and (1,1,0) != 211)}
rule : {(0,0,0) - 203} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 20 or (1,0,0) = 10 or (1,0,0) = 0) and ((2,0,0) = 0 or (2,0,0) = 10 or (2,0,0) = 20) and ((1,1,0) != 204 and (1,1,0) != 214)}
rule : {(0,0,0)} 0 {t}

[URcorner-rule]
%PART 1 - CELLS WITH NO ROBOTS.
rule : {(0,0,0)} 0 {(0,0,0) = 30 or (0,0,0) = 40}
%PART 2 - SCAN THE GROUND AND MAP IF NOT ALREADY DONE.  
%IF ALREADY SCANNED AND MAPPED, JUST MOVE.
%IF CONFLICT WITH OTHER ROBOT, MOVE AWAY.
%Direction selection.
rule : { if( round(uniform(201,204)) = 201, 203, if( round(uniform(201,204)) = 202, 204, if( round(uniform(201,204)) = 203, 203, if( round(uniform(201,204)) = 204, 204, 204))))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
rule : { if( round(uniform(211,214)) = 211, 213, if( round(uniform(211,214)) = 212, 214, if( round(uniform(211,214)) = 213, 213, if( round(uniform(211,214)) = 214, 214, 214))))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
rule : { if( round(uniform(201,204)) = 201, 203, if( round(uniform(201,204)) = 202, 204, if( round(uniform(201,204)) = 203, 203, if( round(uniform(201,204)) = 204, 204, 204))))} 200 {(0,0,0) = 100}
rule : { if( round(uniform(211,214)) = 211, 213, if( round(uniform(211,214)) = 212, 214, if( round(uniform(211,214)) = 213, 213, if( round(uniform(211,214)) = 214, 214, 214))))} 200 {(0,0,0) = 110}
%rule : { round(uniform(203,204))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
%rule : { round(uniform(213,214))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
%rule : { round(uniform(203,204))} 200 {(0,0,0) = 100}
%rule : { round(uniform(213,214))} 200 {(0,0,0) = 110}
%Resolution of conflicts with other robots.
rule : {(0,0,0) - 1} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-2,0) = 202 or (0,-2,0) = 212) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((2,0,0) = 201 or (2,0,0) = 211) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,-1,0) = 202 or (1,-1,0) = 212) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((1,-1,0) = 201 or (1,-1,0) = 211) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 201 or (1,0,0) = 211)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 202 or (0,-1,0) = 212)}
%PART 3 - MOVING
%Move.
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((1,0,0) = 201 or (1,0,0) = 211) and ((0,-1,0) != 202 and (0,-1,0) != 212)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,-1,0) = 202 or (0,-1,0) = 212) and ((1,0,0) != 201 and (1,0,0) != 211)}
%Clear previous cell
rule : {(0,0,0) - 203} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 20 or (1,0,0) = 10 or (1,0,0) = 0) and ((2,0,0) = 0 or (2,0,0) = 10 or (2,0,0) = 20) and ((1,-1,0) != 202 and (1,-1,0) != 212)}
rule : {(0,0,0) - 204} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 20 or (0,-1,0) = 10 or (0,-1,0) = 0) and ((0,-2,0) = 0 or (0,-2,0) = 10 or (0,-2,0) = 20) and ((1,-1,0) != 201 and (1,-1,0) != 211)}
rule : {(0,0,0)} 0 {t}

[BLcorner-rule]
%PART 1 - CELLS WITH NO ROBOTS.
rule : {(0,0,0)} 0 {(0,0,0) = 30 or (0,0,0) = 40}
%PART 2 - SCAN THE GROUND AND MAP IF NOT ALREADY DONE.  
%IF ALREADY SCANNED AND MAPPED, JUST MOVE.
%IF CONFLICT WITH OTHER ROBOT, MOVE AWAY.
%Direction selection.
rule : { if( round(uniform(201,204)) = 201, 201, if( round(uniform(201,204)) = 202, 202, if( round(uniform(201,204)) = 203, 201, if( round(uniform(201,204)) = 204, 202, 202))))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
rule : { if( round(uniform(211,214)) = 211, 211, if( round(uniform(211,214)) = 212, 212, if( round(uniform(211,214)) = 213, 211, if( round(uniform(211,214)) = 214, 212, 212))))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
rule : { if( round(uniform(201,204)) = 201, 201, if( round(uniform(201,204)) = 202, 202, if( round(uniform(201,204)) = 203, 201, if( round(uniform(201,204)) = 204, 202, 202))))} 200 {(0,0,0) = 100}
rule : { if( round(uniform(211,214)) = 211, 211, if( round(uniform(211,214)) = 212, 212, if( round(uniform(211,214)) = 213, 211, if( round(uniform(211,214)) = 214, 212, 212))))} 200 {(0,0,0) = 110}
%rule : { round(uniform(201,202))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
%rule : { round(uniform(211,212))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
%rule : { round(uniform(201,202))} 200 {(0,0,0) = 100}
%rule : { round(uniform(211,212))} 200 {(0,0,0) = 110}
%Resolution of conflicts with other robots.
rule : {(0,0,0) - 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,2,0) = 204 or (0,2,0) = 214) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-2,0,0) = 203 or (-2,0,0) = 213) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((-1,1,0) = 203 or (-1,1,0) = 213) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0)} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,1,0) = 204 or (-1,1,0) = 214) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 203 or (-1,0,0) = 213)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 204 or (0,1,0) = 214)}
%PART 3 - MOVING
%Move.
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((-1,0,0) = 203 or (-1,0,0) = 213) and ((0,1,0) != 204 and (0,1,0) != 214)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,1,0) = 204 or (0,1,0) = 214) and ((-1,0,0) != 203 and (-1,0,0) != 213)}
%Clear previous cell
rule : {(0,0,0) - 201} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 20 or (-1,0,0) = 10 or (-1,0,0) = 0) and ((-2,0,0) = 0 or (-2,0,0) = 10 or (-2,0,0) = 20) and ((-1,1,0) != 204 and (-1,1,0) != 214)}
rule : {(0,0,0) - 202} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 20 or (0,1,0) = 10 or (0,1,0) = 0) and ((0,2,0) = 0 or (0,2,0) = 10 or (0,2,0) = 20) and ((-1,1,0) != 203 and (-1,1,0) != 213)}
rule : {(0,0,0)} 0 {t}

[BRcorner-rule]
%PART 1 - CELLS WITH NO ROBOTS.
rule : {(0,0,0)} 0 {(0,0,0) = 30 or (0,0,0) = 40}
%PART 2 - SCAN THE GROUND AND MAP IF NOT ALREADY DONE.  
%IF ALREADY SCANNED AND MAPPED, JUST MOVE.
%IF CONFLICT WITH OTHER ROBOT, MOVE AWAY.
%Direction selection.
rule : { if( round(uniform(201,204)) = 202, 201, if( round(uniform(201,204)) = 201, 201, if( round(uniform(201,204)) = 203, 204, if( round(uniform(201,204)) = 204, 204, 204))))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
rule : { if( round(uniform(211,214)) = 212, 211, if( round(uniform(211,214)) = 211, 211, if( round(uniform(211,214)) = 213, 214, if( round(uniform(211,214)) = 214, 214, 214))))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
rule : { if( round(uniform(201,204)) = 202, 201, if( round(uniform(201,204)) = 201, 201, if( round(uniform(201,204)) = 203, 204, if( round(uniform(201,204)) = 204, 204, 204))))} 200 {(0,0,0) = 100}
rule : { if( round(uniform(211,214)) = 212, 211, if( round(uniform(211,214)) = 211, 211, if( round(uniform(211,214)) = 213, 214, if( round(uniform(211,214)) = 214, 214, 214))))} 200 {(0,0,0) = 110}
%rule : 201 200 {(0,0,0) = 120 and (0,0,1) = 30}
%rule : 214 200 {(0,0,0) = 120 and (0,0,1) = 40}
%rule : 201 200 {(0,0,0) = 100}
%rule : 214 200 {(0,0,0) = 110}
%Resolution of conflicts with other robots.
rule : {(0,0,0) - 3} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-2,0) = 202 or (0,-2,0) = 212) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 3} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-2,0,0) = 203 or (-2,0,0) = 213) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0)} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,-1,0) = 202 or (-1,-1,0) = 212) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0)} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((-1,-1,0) = 203 or (-1,-1,0) = 213) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 3} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 203 or (-1,0,0) = 213)}

rule : {(0,0,0) - 3} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 202 or (0,-1,0) = 212)}
%PART 3 - MOVING
%Move.
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,-1,0) = 202 or (0,-1,0) = 212) and ((-1,0,0) != 203 and (-1,0,0) != 213)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((-1,0,0) = 203 or (-1,0,0) = 213) and ((0,-1,0) != 202 and (0,-1,0) != 212)}
%Clear previous cell
rule : {(0,0,0) - 201} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 20 or (-1,0,0) = 10 or (-1,0,0) = 0) and ((-2,0,0) = 0 or (-2,0,0) = 10 or (-2,0,0) = 20) and ((-1,-1,0) != 202 and (-1,-1,0) != 212)}
rule : {(0,0,0) - 204} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 20 or (0,-1,0) = 10 or (0,-1,0) = 0) and ((0,-2,0) = 0 or (0,-2,0) = 10 or (0,-2,0) = 20) and ((-1,-1,0) != 203 and (-1,-1,0) != 213)}
rule : {(0,0,0)} 0 {t}

[top-rule]
%PART 1 - CELLS WITH NO ROBOTS.
rule : {(0,0,0)} 0 {(0,0,0) = 30 or (0,0,0) = 40}
%PART 2 - SCAN THE GROUND AND MAP IF NOT ALREADY DONE.  
%IF ALREADY SCANNED AND MAPPED, JUST MOVE.
%IF CONFLICT WITH OTHER ROBOT, MOVE AWAY.
%Direction selection.
rule : { if( round(uniform(201,204)) = 201, 204, if( round(uniform(201,204)) = 202, 202, if( round(uniform(201,204)) = 203, 203, if( round(uniform(201,204)) = 204, 204, 204))))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
rule : { if( round(uniform(211,214)) = 211, 214, if( round(uniform(211,214)) = 212, 212, if( round(uniform(211,214)) = 213, 213, if( round(uniform(211,214)) = 214, 214, 214))))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
rule : { if( round(uniform(201,204)) = 201, 204, if( round(uniform(201,204)) = 202, 202, if( round(uniform(201,204)) = 203, 203, if( round(uniform(201,204)) = 204, 204, 204))))} 200 {(0,0,0) = 100}
rule : { if( round(uniform(211,214)) = 211, 214, if( round(uniform(211,214)) = 212, 212, if( round(uniform(211,214)) = 213, 213, if( round(uniform(211,214)) = 214, 214, 214))))} 200 {(0,0,0) = 110}
%rule : { round(uniform(202,204))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
%rule : { round(uniform(212,214))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
%rule : { round(uniform(202,204))} 200 {(0,0,0) = 100}
%rule : { round(uniform(212,214))} 200 {(0,0,0) = 110}
%Resolution of conflicts with other robots.
rule : {(0,0,0) + 2} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,2,0) = 204 or (0,2,0) = 214) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20)}
rule : {(0,0,0) - 2} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-2,0) = 202 or (0,-2,0) = 212) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((2,0,0) = 201 or (2,0,0) = 211) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20)}

rule : {(0,0,0) + 2} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((1,1,0) = 201 or (1,1,0) = 211) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,-1,0) = 202 or (1,-1,0) = 212) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,1,0) = 204 or (1,1,0) = 214) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20)}

rule : {(0,0,0) - 2} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((1,-1,0) = 201 or (1,-1,0) = 211) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 201 or (1,0,0) = 211)}

rule : {(0,0,0) + 2} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 204 or (0,1,0) = 214)}
rule : {(0,0,0) - 2} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 202 or (0,-1,0) = 212)}
%PART 3 - MOVING
%Move.
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((1,0,0) = 201 or (1,0,0) = 211) and ((0,-1,0) != 202 and (0,-1,0) != 212 and (0,1,0) != 204 and (0,1,0) != 214)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,-1,0) = 202 or (0,-1,0) = 212) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20) and ((1,0,0) != 201 and (1,0,0) != 211)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,1,0) = 204 or (0,1,0) = 214) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20) and ((1,0,0) != 201 and (1,0,0) != 211)}
%Clear previous cell
rule : {(0,0,0) - 202} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 20 or (0,1,0) = 10 or (0,1,0) = 0) and ((0,2,0) = 0 or (0,2,0) = 10 or (0,2,0) = 20 or (0,2,0) = ?) and ((1,1,0) != 201 and (1,1,0) != 211)}
rule : {(0,0,0) - 203} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 20 or (1,0,0) = 10 or (1,0,0) = 0) and ((2,0,0) = 0 or (2,0,0) = 10 or (2,0,0) = 20) and ((1,1,0) != 204 and (1,1,0) != 214 and (1,-1,0) != 202 and (1,-1,0) != 212)}
rule : {(0,0,0) - 204} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 20 or (0,-1,0) = 10 or (0,-1,0) = 0) and ((0,-2,0) = 0 or (0,-2,0) = 10 or (0,-2,0) = 20 or (0,-2,0) = ?) and ((1,-1,0) != 201 and (1,-1,0) != 211)}
rule : {(0,0,0)} 0 {t}

[bottom-rule]
%PART 1 - CELLS WITH NO ROBOTS.
rule : {(0,0,0)} 0 {(0,0,0) = 30 or (0,0,0) = 40}
%PART 2 - SCAN THE GROUND AND MAP IF NOT ALREADY DONE.  
%IF ALREADY SCANNED AND MAPPED, JUST MOVE.
%IF CONFLICT WITH OTHER ROBOT, MOVE AWAY.
%Direction selection.
rule : { if( round(uniform(201,204)) = 203, 201, if( round(uniform(201,204)) = 201, 201, if( round(uniform(201,204)) = 202, 202, if( round(uniform(201,204)) = 204, 204, 204))))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
rule : { if( round(uniform(211,214)) = 213, 211, if( round(uniform(211,214)) = 211, 211, if( round(uniform(211,214)) = 212, 212, if( round(uniform(211,214)) = 214, 214, 214))))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
rule : { if( round(uniform(201,204)) = 203, 201, if( round(uniform(201,204)) = 201, 201, if( round(uniform(201,204)) = 202, 202, if( round(uniform(201,204)) = 204, 204, 204))))} 200 {(0,0,0) = 100}
rule : { if( round(uniform(211,214)) = 213, 211, if( round(uniform(211,214)) = 211, 211, if( round(uniform(211,214)) = 212, 212, if( round(uniform(211,214)) = 214, 214, 214))))} 200 {(0,0,0) = 110}
%rule : 201 200 {(0,0,0) = 120 and (0,0,1) = 30}
%rule : 211 200 {(0,0,0) = 120 and (0,0,1) = 40}
%rule : 201 200 {(0,0,0) = 100}
%rule : 211 200 {(0,0,0) = 110}
%Resolution of conflicts with other robots.
rule : {(0,0,0) + 2} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,2,0) = 204 or (0,2,0) = 214) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20)}
rule : {(0,0,0) - 2} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-2,0) = 202 or (0,-2,0) = 212) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-2,0,0) = 203 or (-2,0,0) = 213) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,-1,0) = 202 or (-1,-1,0) = 212) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) + 2} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((-1,1,0) = 203 or (-1,1,0) = 213) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) - 2} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((-1,-1,0) = 203 or (-1,-1,0) = 213) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) + 3} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,1,0) = 204 or (-1,1,0) = 214) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 203 or (-1,0,0) = 213)}

rule : {(0,0,0) + 2} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 204 or (0,1,0) = 214)}
rule : {(0,0,0) - 2} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 202 or (0,-1,0) = 212)}
%PART 3 - MOVING
%Move.
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,-1,0) = 202 or (0,-1,0) = 212) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20) and ((-1,0,0) != 203 and (-1,0,0) != 213)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((-1,0,0) = 203 or (-1,0,0) = 213) and ((0,-1,0) != 202 and (0,-1,0) != 212 and (0,1,0) != 204 and (0,1,0) != 214)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,1,0) = 204 or (0,1,0) = 214) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20) and ((-1,0,0) != 203 and (-1,0,0) != 213)}
%Clear previous cell
rule : {(0,0,0) - 201} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 20 or (-1,0,0) = 10 or (-1,0,0) = 0) and ((-2,0,0) = 0 or (-2,0,0) = 10 or (-2,0,0) = 20) and ((-1,-1,0) != 202 and (-1,-1,0) != 212 and (-1,1,0) != 204 and (-1,1,0) != 214)}
rule : {(0,0,0) - 202} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 20 or (0,1,0) = 10 or (0,1,0) = 0) and ((0,2,0) = 0 or (0,2,0) = 10 or (0,2,0) = 20 or (0,2,0) = ?) and ((-1,1,0) != 203 and (-1,1,0) != 213)}
rule : {(0,0,0) - 204} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 20 or (0,-1,0) = 10 or (0,-1,0) = 0) and ((0,-2,0) = 0 or (0,-2,0) = 10 or (0,-2,0) = 20 or (0,-2,0) = ?) and ((-1,-1,0) != 203 and (-1,-1,0) != 213)}
rule : {(0,0,0)} 0 {t}

[left-rule]
%PART 1 - CELLS WITH NO ROBOTS.
rule : {(0,0,0)} 0 {(0,0,0) = 30 or (0,0,0) = 40}
%PART 2 - SCAN THE GROUND AND MAP IF NOT ALREADY DONE.  
%IF ALREADY SCANNED AND MAPPED, JUST MOVE.
%IF CONFLICT WITH OTHER ROBOT, MOVE AWAY.
%Direction selection.
rule : { if( round(uniform(201,204)) = 201, 201, if( round(uniform(201,204)) = 202, 202, if( round(uniform(201,204)) = 203, 203, if( round(uniform(201,204)) = 204, 201, 201))))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
rule : { if( round(uniform(211,214)) = 211, 211, if( round(uniform(211,214)) = 212, 212, if( round(uniform(211,214)) = 213, 213, if( round(uniform(211,214)) = 214, 211, 211))))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
rule : { if( round(uniform(201,204)) = 201, 201, if( round(uniform(201,204)) = 202, 202, if( round(uniform(201,204)) = 203, 203, if( round(uniform(201,204)) = 204, 201, 201))))} 200 {(0,0,0) = 100}
rule : { if( round(uniform(211,214)) = 211, 211, if( round(uniform(211,214)) = 212, 212, if( round(uniform(211,214)) = 213, 213, if( round(uniform(211,214)) = 214, 211, 211))))} 200 {(0,0,0) = 110}
%rule : { round(uniform(201,203))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
%rule : { round(uniform(211,213))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
%rule : { round(uniform(201,203))} 200 {(0,0,0) = 100}
%rule : { round(uniform(211,213))} 200 {(0,0,0) = 110}
%Resolution of conflicts with other robots.
rule : {(0,0,0) + 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,2,0) = 204 or (0,2,0) = 214) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20)}

rule : {(0,0,0) - 2} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((2,0,0) = 201 or (2,0,0) = 211) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20)}
rule : {(0,0,0) + 2} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-2,0,0) = 203 or (-2,0,0) = 213) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((1,1,0) = 201 or (1,1,0) = 211) and ((0,1,0) = 0 or (0,1,0) = 10 or (0,1,0) = 20)}

rule : {(0,0,0) + 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((-1,1,0) = 203 or (-1,1,0) = 213) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) - 2} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,1,0) = 204 or (1,1,0) = 214) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20)}

rule : {(0,0,0) + 2} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,1,0) = 204 or (-1,1,0) = 214) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) - 2} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 201 or (1,0,0) = 211)}
rule : {(0,0,0) + 2} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 203 or (-1,0,0) = 213)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 204 or (0,1,0) = 214)}
rule : {(0,0,0) - 1} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 202 or (0,-1,0) = 212)}
%PART 3 - MOVING
%Move.
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((1,0,0) = 201 or (1,0,0) = 211) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20) and ((0,1,0) != 204 and (0,1,0) != 214)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((-1,0,0) = 203 or (-1,0,0) = 213) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20) and ((0,1,0) != 204 and (0,1,0) != 214)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,1,0) = 204 or (0,1,0) = 214) and ((-1,0,0) != 203 and (-1,0,0) != 213 and (1,0,0) != 201 and (1,0,0) != 211)}
%Clear previous cell
rule : {(0,0,0) - 201} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 20 or (-1,0,0) = 10 or (-1,0,0) = 0) and ((-2,0,0) = 0 or (-2,0,0) = 10 or (-2,0,0) = 20 or (-2,0,0) = ?) and ((-1,1,0) != 204 and (-1,1,0) != 214)}
rule : {(0,0,0) - 202} 200 {((0,0,0) = 202 or (0,0,0) = 212) and ((0,1,0) = 20 or (0,1,0) = 10 or (0,1,0) = 0) and ((0,2,0) = 0 or (0,2,0) = 10 or (0,2,0) = 20) and ((-1,1,0) != 203 and (-1,1,0) != 213 and (1,1,0) != 201 and (1,1,0) != 211)}
rule : {(0,0,0) - 203} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 20 or (1,0,0) = 10 or (1,0,0) = 0) and ((2,0,0) = 0 or (2,0,0) = 10 or (2,0,0) = 20 or (2,0,0) = ?) and ((1,1,0) != 204 and (1,1,0) != 214)}
rule : {(0,0,0)} 0 {t}

[right-rule]
%PART 1 - CELLS WITH NO ROBOTS.
rule : {(0,0,0)} 0 {(0,0,0) = 30 or (0,0,0) = 40}
%PART 2 - SCAN THE GROUND AND MAP IF NOT ALREADY DONE.  
%IF ALREADY SCANNED AND MAPPED, JUST MOVE.
%IF CONFLICT WITH OTHER ROBOT, MOVE AWAY.
%Direction selection.
rule : { if( round(uniform(201,204)) = 202, 204, if( round(uniform(201,204)) = 201, 201, if( round(uniform(201,204)) = 203, 203, if( round(uniform(201,204)) = 204, 204, 204))))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
rule : { if( round(uniform(211,214)) = 212, 214, if( round(uniform(211,214)) = 211, 211, if( round(uniform(211,214)) = 213, 213, if( round(uniform(211,214)) = 214, 214, 214))))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
rule : { if( round(uniform(201,204)) = 202, 204, if( round(uniform(201,204)) = 201, 201, if( round(uniform(201,204)) = 203, 203, if( round(uniform(201,204)) = 204, 204, 204))))} 200 {(0,0,0) = 100}
rule : { if( round(uniform(211,214)) = 212, 214, if( round(uniform(211,214)) = 211, 211, if( round(uniform(211,214)) = 213, 213, if( round(uniform(211,214)) = 214, 214, 214))))} 200 {(0,0,0) = 110}
%rule : { round(uniform(203,204))} 200 {(0,0,0) = 120 and (0,0,1) = 30}
%rule : { round(uniform(213,214))} 200 {(0,0,0) = 120 and (0,0,1) = 40}
%rule : { round(uniform(203,204))} 200 {(0,0,0) = 100}
%rule : { round(uniform(213,214))} 200 {(0,0,0) = 110}
%Resolution of conflicts with other robots.
rule : {(0,0,0) - 3} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-2,0) = 202 or (0,-2,0) = 212) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) - 2} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((2,0,0) = 201 or (2,0,0) = 211) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20)}
rule : {(0,0,0) + 2} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-2,0,0) = 203 or (-2,0,0) = 213) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) + 2} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,-1,0) = 202 or (-1,-1,0) = 212) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20)}

rule : {(0,0,0) - 2} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,-1,0) = 202 or (1,-1,0) = 212) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((-1,-1,0) = 203 or (-1,-1,0) = 213) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) - 3} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((1,-1,0) = 201 or (1,-1,0) = 211) and ((0,-1,0) = 0 or (0,-1,0) = 10 or (0,-1,0) = 20)}

rule : {(0,0,0) - 2} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 201 or (1,0,0) = 211)}
rule : {(0,0,0) + 2} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 203 or (-1,0,0) = 213)}

rule : {(0,0,0) - 1} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 202 or (0,-1,0) = 212)}
%PART 3 - MOVING
%Move.
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((1,0,0) = 201 or (1,0,0) = 211) and ((-1,0,0) = 0 or (-1,0,0) = 10 or (-1,0,0) = 20) and ((0,-1,0) != 202 and (0,-1,0) != 212)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((0,-1,0) = 202 or (0,-1,0) = 212) and ((1,0,0) != 201 and (1,0,0) != 211 and (-1,0,0) != 203 and (-1,0,0) != 213)}
rule : {(0,0,0) + 100} 200 {((0,0,0) = 0 or (0,0,0) = 10 or (0,0,0) = 20) and ((-1,0,0) = 203 or (-1,0,0) = 213) and ((1,0,0) = 0 or (1,0,0) = 10 or (1,0,0) = 20) and ((0,-1,0) != 202 and (0,-1,0) != 212)}
%Clear previous cell
rule : {(0,0,0) - 201} 200 {((0,0,0) = 201 or (0,0,0) = 211) and ((-1,0,0) = 20 or (-1,0,0) = 10 or (-1,0,0) = 0) and ((-2,0,0) = 0 or (-2,0,0) = 10 or (-2,0,0) = 20 or (-2,0,0) = ?) and ((-1,-1,0) != 202 and (-1,-1,0) != 212)}
rule : {(0,0,0) - 203} 200 {((0,0,0) = 203 or (0,0,0) = 213) and ((1,0,0) = 20 or (1,0,0) = 10 or (1,0,0) = 0) and ((2,0,0) = 0 or (2,0,0) = 10 or (2,0,0) = 20 or (2,0,0) = ?) and ((1,-1,0) != 202 and (1,-1,0) != 212)}
rule : {(0,0,0) - 204} 200 {((0,0,0) = 204 or (0,0,0) = 214) and ((0,-1,0) = 20 or (0,-1,0) = 10 or (0,-1,0) = 0) and ((0,-2,0) = 0 or (0,-2,0) = 10 or (0,-2,0) = 20) and ((-1,-1,0) != 203 and (-1,-1,0) != 213)}
rule : {(0,0,0)} 0 {t}



