/*************************************************************************
*	AUTHOR		: Jan Mikhail
*	Email		: janmikhail@cmail.carleton.ca
*	DATE		: 15-01-2014
*************************************************************************/

#ifndef LOGMANAGER_H_
#define LOGMANAGER_H_

#include <math.h>
#include <stdio.h>
#include "time.h"
#include "mainsimu.h"
#include "Log.h"
#include "atomic.h"
#include <stdlib.h>

using namespace std;

class LogManager: public Atomic{
       
	public:	
		LogManager(const string &name = "LogManager");
		virtual string className() const {return "LogManager";}
	
		std::string areaConfig;
		int frequency;
		int bsCounter;
		int ueCounter;
		int distanceRange;

	protected:
		Model &initFunction();
		Model &externalFunction( const ExternalMessage & );
		Model &internalFunction( const InternalMessage & );
		Model &outputFunction( const InternalMessage &);

	private:

};



#endif /*LOGMANAGER_H_*/
