/********************************************************
*	DESCRIPTION	: Msg
* 
*	AUTHOR		: Baha Uddin Kazi, Mohammad Etemad
*	Email		: 
*	DATE		: 18-08-2013
* 
*
********************************************************/


#ifndef MSG_H
#define MSG_H

#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <sstream>
#include <iostream>
#include <vector>
#define COMP_REQ 1
#define COMP_ACK 2
#define COMP_NOTIFY 3
#define CSI_FEEDBACK 4
#define COMP_REQGR 5
#define COMP_CMD 6
#define CTRL_MeNB 7
#define CSI_FEEDBACKFWD 8
#define COMP_NOTIFYPeNB 9
#define HO_REQ 11
#define HO_ACK 12
#define HO_CMD 13
#define MES_REP 14


#define MSG_INTERNAL 100 //Any message type equal to or higher than MSG_INTERNAL is intended as a message to the switch

using namespace std;

class Msg {
	public: 
		Msg(long sourceID, long destinationID, int messageType);
		Msg();
		virtual ~Msg();

		long getDestID() const{return destID;}
		void setDestID(long des){destID = des;} 
		
		long getSrcID() const{return srcID;}
		void setSrcID(long src){srcID = src;} 

				//		long getDestID() const{return destID;}
				//		void setDestID(long des){destID = des;}
					 
				//		long getDestID() const{return destID;}
				//		void setDestID(long des){destID = des;} 

		long getDelay() const{return delay;}
		void setDelay(long dly){delay = dly;}

		long getSendTime() const{return sendTime;}
		void setSendTime(long sendT){sendTime = sendT;}
	
		long getMsgT() const{return msgType;}
		//void setMsgT(long MsgT){msgType = MsgT;} 

		std::string getMsgTypeS(int msgT);

	private:
		long srcID;
		long destID;
		long srcType;
		long destType;
		int msgType;
		float delay;
		float sendTime;
};




class CoMPReq: public Msg {
	public: 
		CoMPReq(long sourceID, long destinationID, short request, long throughput, long ccsID, long SourceCSIueID, std::vector<long>& CoMPmembers); 
		CoMPReq();
		~CoMPReq();
	
		short getReq() const{return req;}
		long getThroughput() const{return Thput;}
		long getccsID() const{return ID;}
		long getSourceCSIueID() const{return ueID;}
		std::vector<long> getCoMPmembers() {return CoMPmember;}			

	private:
		short req;
		long Thput;
		long ID;
		long ueID;
		std::vector<long> CoMPmember;
};

class CoMPAck: public Msg { 
	public: 
		CoMPAck(long sourceID, long destinationID, short ack);
		CoMPAck();
		~CoMPAck();
	
		short getAck() const{return acknowledge;}
		
	private:
		short acknowledge;
};



class CoMPReqGR: public Msg { 
	public: 
		CoMPReqGR(long sourceID, long destinationID, short ackGR, long throughput, long ccsID, long SourceCSIueID, std::vector<long>& CoMPmembers);
		CoMPReqGR();
		~CoMPReqGR();
	
		short getReqGR() const{return acknowledgeGR;}
		long getThroughput() const{return Thput;}
		long getccsID() const{return ID;}
		long getSourceCSIueID() const{return ueID;}	
		std::vector<long> getCoMPmembers() {return CoMPmember;}		

	private:
		short acknowledgeGR;
		long Thput;
		long ID;
		long ueID;
		std::vector<long> CoMPmember;
};
	
class CoMPNotify: public Msg {
	public: 
		CoMPNotify(long sourceID, long destinationID, short Notify, long ccsID, long throughput, long SourceCSIueID);
		CoMPNotify();
		~CoMPNotify();
		
		long getCCSThroughput() const{return CCSThput;}
		short getNotify() const{return notify;}
		long getccsID() const{return ID;}
		long getSourceCSIueID() const{return ueID;}	
	
	private:
		short notify;
		long CCSThput;
		long ID;
		long ueID;
};

class CoMPNotifyPeNB: public Msg {
	public: 
		CoMPNotifyPeNB(long sourceID, long destinationID, short Notify, long ccsID, long throughput, long SourceCSIueID,  std::vector<long>& vec);
		CoMPNotifyPeNB();
		~CoMPNotifyPeNB();
		
		long getCCSThroughput() const{return CCSThput;}
		short getNotify() const{return notify;}
		long getccsID() const{return ID;}
		long getSourceCSIueID() const{return ueID;}
		std::vector<long> getPeNBmembers() {return member;}	
	
	private:
		short notify;
		long CCSThput;
		long ID;
		long ueID;
		std::vector<long> member;
};

class CoMPCmd: public Msg {
	public: 
		CoMPCmd(long sourceID, long destinationID, short Command, long ccsID);
		CoMPCmd();
		~CoMPCmd();
	
		short getCmd() const{return command;}
		long getccsID() const{return ID;}	
	
	private:
		short command;
		long ID;
};



class CSIFeedbackFwd: public Msg {
	public: 
		CSIFeedbackFwd(long sourceID, long destinationID, long maximumRecPower, std::vector<long>& setMembersVec, std::vector<long>& powersVec, long sourceUEID, int UEinCoMP);
		CSIFeedbackFwd();
		~CSIFeedbackFwd();
		
		long getDestCSI() const{return maxPower;}
		std::vector<long> getCoMPmembers() {return memberV;}	
		std::vector<long> getPower() {return powerV;}	
		long getSourceUEID() const{return ueID;}
		int getCoMPStatus() {return isInCoMP;}
	private:
		long maxPower;
		long ueID;
		std::vector<long> memberV;
		std::vector<long> powerV;
		int isInCoMP;
};

/////////////////////////////////////////////////////////////used messages//////////////////////////////////////////////////////////////////////////

class CTRLCmd: public Msg {
	public: 
		CTRLCmd(long sourceID, long destinationID, long MeNBx, long MeNBy, long MeNBf, long MeNBp);
		CTRLCmd();
		~CTRLCmd();
		
		long getMeNBx() const{return x;}
		long getMeNBy() const{return y;}
		long getFreq() const{return f;}
		long getMeNBPower() const{return p;}
	private:
		long x;
		long y;
		long f;
		long p;
};


class CSIFeedback: public Msg {
	public: 
		CSIFeedback(long sourceID, long destinationID, long maximumRecPower, std::vector<long>& setMembersVec, std::vector<long>& powersVec, int UEinCoMP);
		CSIFeedback();
		~CSIFeedback();
		
		long getDestCSI() const{return maxPower;}
		int getCoMPStatus() {return isInCoMP;}
		std::vector<long> getCoMPmembers() {return memberV;}	
		std::vector<long> getPower() {return powerV;}	
	private:
		long maxPower;
		int isInCoMP;
		std::vector<long> memberV;
		std::vector<long> powerV;
};


class HOReq: public Msg {
	public: 
		HOReq(long sourceID, long destinationID, short request, long targetID, long SourceUEid/*, long throughput , std::vector<long>& HOmembers*/); 
		HOReq();
		~HOReq();
	
		short getReq() const{return req;}
		//long getThroughput() const{return Thput;}
		long getTargetID() const{return ID;}
		long getSourceUEid() const{return ueID;}
		//std::vector<long> getHOmembers() {return HOmember;}			

	private:
		short req;
		//long Thput;
		long ID;
		long ueID;
		//std::vector<long> HOmember;
};




class MeasurementReport: public Msg {
	public: 
		MeasurementReport(long sourceID, long destinationID, long maximumRecPower,long targetID, std::vector<long>& setMembersVec, std::vector<long>& powersVec, int UEinCoMP);
		MeasurementReport();
		~MeasurementReport();
		
		long getDestMR() const{return maxPower;}
		long getTargetID() {return targetID;}
		int getCoMPStatus() {return isInCoMP;}
		std::vector<long> getCoMPmembers() {return memberV;}	
		std::vector<long> getPower() {return powerV;}	
	private:
		long maxPower,targetID;
		int isInCoMP;
		std::vector<long> memberV;
		std::vector<long> powerV;
};


class RRCConnReconf: public Msg {
	public: 
		RRCConnReconf(long sourceID, long destinationID, short Command, long targetID);
		RRCConnReconf();
		~RRCConnReconf();
	
		short getCmd() const{return command;}
		long getTargetID() const{return ID;}	
	
	private:
		short command;
		long ID;
};

class HOReqAck: public Msg { 
	public: 
		HOReqAck(long sourceID, long destinationID, short ackGR, long targetID, long SourceUEid /*, long throughput , std::vector<long>& HOmembers*/);
		HOReqAck();
		~HOReqAck();
	
		short getHOReqAck() const{return acknowledgeGR;}
		//long getThroughput() const{return Thput;}
		long getTargetID() const{return ID;}
		long getSourceUEid() const{return ueID;}	
		//std::vector<long> getHOmembers() {return HOmember;}		

	private:
		short acknowledgeGR;
		//long Thput;
		long ID;
		long ueID;
		//std::vector<long> HOmember;
};


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////




#endif  //_MSG_H

