/*************************************************************************
*	AUTHOR		: Jan Mikhail
*	Email		: janmikhail@cmail.carleton.ca
*	DATE		: 15-01-2014
*************************************************************************/

#include "LogManager.h"
#include <stdlib.h>
#include <iostream>
#include <fstream>
	
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: LogManager
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
LogManager::LogManager(const string &name) :
	Atomic(name){

	//area configuration
	string areaConfigurationS( MainSimulator::Instance().getParameter( description(), "areaConfiguration" ) ) ;
	int areaConfiguration;
	if (areaConfigurationS != "") areaConfiguration = atoi(areaConfigurationS.c_str());
	if ( areaConfiguration == 0) areaConfig = "rural";
	if ( areaConfiguration == 1) areaConfig = "urban";
	if ( areaConfiguration == 2) areaConfig = "urban";

	//frequency
	string frequencyS( MainSimulator::Instance().getParameter( description(), "frequency" ) ) ;
	if (frequencyS!="") frequency = atoi(frequencyS.c_str());

	//number of BSs
	string bsCounterS( MainSimulator::Instance().getParameter( description(), "bsCounter" ) ) ;
	if (bsCounterS!="") bsCounter = atoi(bsCounterS.c_str());	

	//number of UEs
	string ueCounterS( MainSimulator::Instance().getParameter( description(), "ueCounter" ) ) ;
	if (ueCounterS!="") ueCounter = atoi(ueCounterS.c_str());	

	//distance range
	string distanceRangeS( MainSimulator::Instance().getParameter( description(), "distanceRange" ) ) ;
	if (distanceRangeS!="") distanceRange = atoi(distanceRangeS.c_str());	
}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: initial function
*Description: Init function for DEVS atomic model 
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
Model &LogManager::initFunction(){ return *this; }


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: external function
*Description: External function for DEVS atomic model 
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/	
Model &LogManager::externalFunction(const ExternalMessage &msg ){ return *this; }


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: internal function
*Description: Internal function for DEVS atomic model 
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/	
Model &LogManager::internalFunction(const InternalMessage &msg ){
	passivate();
	return *this;
}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: output function
*Description: Output function for DEVS atomic model 
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/	
Model &LogManager::outputFunction(const InternalMessage &msg ){ return *this; }

