/*******************************************************************
*
*  DESCRIPTION: class Atomic
*
*  AUTHOR:    Amir Barylko & Jorge Beyoglonian 
*  Version 2: Daniel A. Rodriguez
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*         mailto://drodrigu@dc.uba.ar
*
*  DATE: 27/6/1998
*  DATE: 25/4/1999
*
*******************************************************************/

/** include files **/
#include "atomic.h"             // base header

/*******************************************************************
* Function Name: holdIn
* Description: Changes the atomic state and the time left to the next change 
********************************************************************/
Model &Atomic::holdIn( const State &s, const Time &t )
{
	state( s );
	nextChange( t );
	return *this;
}

/*******************************************************************
* Function Name: passivate
* Description: Sets thes passive state and the next change to infinity 
********************************************************************/
Model &Atomic::passivate()
{
	state( passive );
	nextChange( Time::Inf );
	return *this;
}
