
#define _USE_MATH_DEFINES
#include <iostream>
#include <vector>
#include <cmath>
#include "Point.h"
#include "polarPoint.h"
#include "PeNB.h"
using namespace std;


PeNB::PeNB(Point position,double radius, int id, int power, int freq): 
	position(position),radius(radius), id(id), power(power), freq(freq)
{		
	regionCommonAreas;			
}

Point& PeNB::getPosition(void)
{
	return position;
}

double PeNB::getRadius(void)
{
	return radius;
}
int PeNB::getID(void)
{
	return id;
}
int PeNB::getPower(void)
{
	return power;
}
int PeNB::getFreq(void)
{
	return freq;
}

vector<Point>& PeNB::getRegionCommonAreas(void)
{
	return regionCommonAreas;
}

void PeNB::setPosition(Point point)
{
	this->position = point;
}

void PeNB::setRadius(double radius)
{
	this->radius = radius;
}

void PeNB::setID(int id)
{
	this->id = id;
}

void PeNB::setPower(int power)
{
	this->power = power;
}

void PeNB::setFreq(int freq)
{
	this->freq = freq;
}


void PeNB::setRegionCommonAreas(vector<Point> regionCommonAreas)
{
	this->regionCommonAreas = regionCommonAreas;
}

void PeNB::addRegionCommonAreas(Point point)
{
	this->regionCommonAreas.push_back(point);
}

/*int main()
{
	cout << "Test constructor " << endl;
	PeNB rrh(Point(1, 2),100,1,30,900);
	cout << "Test getters " << endl;
	cout << rrh.getPosition().getX() <<endl;
	cout << rrh.getPosition().getY() <<endl;
	cout << rrh.getRadius() <<endl;
	cout << rrh.getID() <<endl;
	cout << rrh.getPower() <<endl;
	cout << rrh.getFreq() <<endl;
	cout << " " << endl;
	cout << " " << endl;
	cout << "Test Setters " << endl;
	rrh.setPosition(Point(5, 10));
	rrh.setRadius(300);
	rrh.setID(2);
	rrh.setPower(50);
	rrh.setFreq(1000);
	cout << rrh.getPosition().getX() <<endl;
	cout << rrh.getPosition().getY() <<endl;
	cout << rrh.getRadius() <<endl;
	cout << rrh.getID() <<endl;
	cout << rrh.getPower() <<endl;
	cout << rrh.getFreq() <<endl;
	cout << " " << endl;
	cout << " " << endl;
	cout << "Test setRegionCommonAreas " << endl;
	rrh.setRegionCommonAreas({polarPoint(1,3), polarPoint(2,3)});
	vector<polarPoint> polar1(rrh.getRegionCommonAreas());
	cout << polar1[0].getRadius() <<endl;
	cout << polar1[0].getAngle() <<endl;
	cout << " " << endl;
	cout << " " << endl;
	cout << polar1[1].getRadius() <<endl;
	cout << polar1[1].getAngle() <<endl;
	cout << " " << endl;
	cout << " " << endl;
	cout << "Test addRegionCommonAreas " << endl;
	rrh.addRegionCommonAreas(polarPoint(1,4));
	polar1=rrh.getRegionCommonAreas();
	cout << "size: " << polar1.size()<< endl;	
	cout << polar1[2].getRadius() <<endl;
	cout << polar1[2].getAngle() <<endl;
	
	return 0;
}*/



