/********************************************************
*	DESCRIPTION	: Msg
* 
*	AUTHOR		: Baha Uddin Kazi, Mohammad Etemad
*	Email		: 
*	DATE		: 
* 
*
********************************************************/



#include <exception>
#include "Msg.h"


#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <vector>
#define MSG_SIZE_BASE 64
using namespace std;

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: Msg
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
Msg::Msg(long sourceID, long destinationID, int messageType){
	this->srcID = sourceID;
	this->destID = destinationID;
	this->msgType = messageType;

	this->delay = 0;
	this->sendTime = 0;
}

std::string Msg::getMsgTypeS(int msgT) {
	if(msgT == COMP_REQ){ return "COMP_REQ"; }
	else if(msgT == COMP_ACK){ return "COMP_ACK"; }
	else if(msgT == COMP_NOTIFY){ return "COMP_NOTIFY";	}
	else if(msgT == CSI_FEEDBACK){ return "CSI_FEEDBACK"; }
	else if(msgT == CSI_FEEDBACKFWD){ return "CSI_FEEDBACKFWD";	}
	else if(msgT == COMP_REQGR){ return "COMP_REQGR"; }
	else if(msgT == COMP_CMD){ return "COMP_CMD"; }
	else if(msgT == CTRL_MeNB){ return "CTRL_MeNB";	}
	else if(msgT == COMP_NOTIFYPeNB){ return "COMP_NOTIFYPeNB";	}
	else if(msgT == HO_REQ){ return "HO_REQ"; }
	else if(msgT == HO_ACK){ return "HO_ACK"; }
	else if(msgT == HO_CMD){ return "HO_CMD"; }
	else if(msgT == MES_REP){ return "MES_REP"; }
	return "--";
}

Msg::Msg(){
}

Msg::~Msg(){

}



/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: CompReq
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
CoMPReq::CoMPReq(long sourceID, long destinationID, short Req, long throughput, long ccsID, long SourceCSIueID, std::vector<long>& CoMPmembers): Msg(sourceID, destinationID, COMP_REQ){
	req = Req;
	Thput = throughput;
	ID = ccsID;
	ueID = SourceCSIueID;
	CoMPmember = CoMPmembers;
}

CoMPReq::~CoMPReq(){

}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: CoMPAck
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
CoMPAck::CoMPAck(long sourceID, long destinationID, short ack): Msg(sourceID, destinationID, COMP_ACK){
	acknowledge = ack;
}

CoMPAck::~CoMPAck(){

}



/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: CoMPReqGR
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
CoMPReqGR::CoMPReqGR(long sourceID, long destinationID, short ackGR, long throughput, long ccsID, long SourceCSIueID, std::vector<long>& CoMPmembers): Msg(sourceID, destinationID, COMP_REQGR){
	acknowledgeGR = ackGR;
	Thput = throughput;
	ID = ccsID;
	ueID = SourceCSIueID;
	CoMPmember = CoMPmembers;
}

CoMPReqGR::~CoMPReqGR(){

}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: CoMPNotify
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
CoMPNotify::CoMPNotify(long sourceID, long destinationID, short Notify, long ccsID,long throughput, long SourceCSIueID): Msg(sourceID, destinationID, COMP_NOTIFY){
	notify = Notify;
	ID = ccsID;
	CCSThput = throughput;
	ueID = SourceCSIueID;
}

CoMPNotify::~CoMPNotify(){

}


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: CoMPCmd
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
CoMPCmd::CoMPCmd(long sourceID, long destinationID, short Command, long ccsID): Msg(sourceID, destinationID, COMP_CMD){
	command = Command;
	ID = ccsID;
}

CoMPCmd::~CoMPCmd(){

}




/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: CSIFeedbackFwd
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
CSIFeedbackFwd::CSIFeedbackFwd(long sourceID, long destinationID, long maximumRecPower, std::vector<long>& setMembersVec, std::vector<long>& powersVec, long sourceUEID, int UEinCoMP): Msg(sourceID, destinationID, CSI_FEEDBACKFWD){
	maxPower = maximumRecPower;
	memberV = setMembersVec;
	powerV = powersVec;
	ueID = sourceUEID;
	isInCoMP = UEinCoMP;
}

CSIFeedbackFwd::~CSIFeedbackFwd(){

}



/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: CoMPNotifyPeNB
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
CoMPNotifyPeNB::CoMPNotifyPeNB(long sourceID, long destinationID, short Notify, long ccsID, long throughput, long SourceCSIueID,  std::vector<long>& vec): Msg(sourceID, destinationID, COMP_NOTIFYPeNB){
	notify = Notify;
	ID = ccsID;
	CCSThput = throughput;
	ueID = SourceCSIueID;
	member = vec;
}

CoMPNotifyPeNB::~CoMPNotifyPeNB(){

}


/////////////////////////////////////////////////////////////used messages//////////////////////////////////////////////////////////////////////////

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: CTRLCmd
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
CTRLCmd::CTRLCmd(long sourceID, long destinationID, long MeNBx, long MeNBy, long MeNBf, long MeNBp): Msg(sourceID, destinationID, CTRL_MeNB){
	x = MeNBx;
	y = MeNBy;
	f = MeNBf;
	p = MeNBp;
}

CTRLCmd::~CTRLCmd(){

}


CSIFeedback::CSIFeedback(long sourceID, long destinationID, long maximumRecPower, std::vector<long>& setMembersVec, std::vector<long>& powersVec, int UEinCoMP): Msg(sourceID, destinationID, CSI_FEEDBACK){
	maxPower = maximumRecPower;
	isInCoMP = UEinCoMP;
	memberV = setMembersVec;
	powerV = powersVec;
}

CSIFeedback::~CSIFeedback(){

}

HOReq::HOReq(long sourceID, long destinationID, short request, long targetID, long SourceUEid /*, long throughput , std::vector<long>& HOmembers*/): Msg(sourceID, destinationID, HO_REQ){
	req = request;
	//Thput = throughput;
	ID = targetID;
	ueID = SourceUEid;
	//HOmember = HOmembers;
}

HOReq::~HOReq(){

}

MeasurementReport::MeasurementReport(long sourceID, long destinationID, long maximumRecPower,long targetID, std::vector<long>& setMembersVec, std::vector<long>& powersVec, int UEinCoMP): Msg(sourceID, destinationID, MES_REP){
	maxPower = maximumRecPower;
	isInCoMP = UEinCoMP;
	memberV = setMembersVec;
	powerV = powersVec;
	this->targetID = targetID;
}

MeasurementReport::~MeasurementReport(){

}





RRCConnReconf::RRCConnReconf(long sourceID, long destinationID, short Command, long targetID): Msg(sourceID, destinationID, HO_CMD){
	command = Command;
	ID = targetID;
}

RRCConnReconf::~RRCConnReconf(){

}


HOReqAck::HOReqAck(long sourceID, long destinationID, short ackGR, long targetID, long SourceUEid /*, long throughput , std::vector<long>& HOmembers*/): Msg(sourceID, destinationID, HO_ACK){
	acknowledgeGR = ackGR;
	//Thput = throughput;
	ID = targetID;
	ueID = SourceUEid;
	//HOmember = HOmembers;
}

HOReqAck::~HOReqAck(){

}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////






