/*******************************************************************
*
*  DESCRIPTION: class Coupled
*
*  AUTHOR:    Amir Barylko & Jorge Beyoglonian 
*  VERSION 2: Daniel Rodriguez
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*         mailto://drodrigu@dc.uba.ar
*
*  DATE: 27/6/1998
*  DATE: 27/2/1999 (v2)
*
*******************************************************************/

/** include files **/
#include <algorithm>
#include "coupled.h"    // base header
#include "procadm.h"	// SingleProcessorAdmin

/** public functions **/
/*******************************************************************
* Function Name: addModel
* Description: add a model to the list of children
********************************************************************/
Model &Coupled::addModel( Model &mod )
{
	mod.parentId( id() );

	ModelList::iterator cursor = find_if( childs.begin(), childs.end(), bind2nd( greater<ModelId>(),  mod.id() ) );

	childs.insert( cursor, mod.id() );

	return *this;
}

/*******************************************************************
* Function Name: addInfluence
* Description: add a link between two ports
********************************************************************/
Model &Coupled::addInfluence( const string &sourceName, const string &sourcePort, const string &destName, const string &destPort) 
{
	Port &port1( SingleProcessorAdmin::Instance().processor( sourceName ).model().port( sourcePort ) );
	Port &port2( SingleProcessorAdmin::Instance().processor( destName ).model().port( destPort ) );

	port1.addInfluence( port2 );
	return *this;
}
