/*******************************************************************
*
*  DESCRIPTION: class ProcessorAdmin, SingleProcessorAdmin
*
*  AUTHOR: Amir Barylko & Jorge Beyoglonian 
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*
*  DATE: 27/6/1998
*
*******************************************************************/

#ifndef __PROCESSOR_ADMIN_H
#define __PROCESSOR_ADMIN_H

/** include files **/
#include <map>
#include "process.h"          // ProcId

/** forward declarations **/
class Atomic;
class Coupled;
class CoupledCell ;
class FlatCoupledCell;
class SingleProcessorAdmin ;
class Root ;

/** declarations **/

class ProcessorAdmin
{
public:
	virtual ~ProcessorAdmin() ; // Destructor

	Processor &generateProcessor( Atomic * ) ;
	Processor &generateProcessor( Coupled * ) ;
	Processor &generateProcessor( CoupledCell * ) ;
	Processor &generateProcessor( FlatCoupledCell * ) ;
	Processor &generateRoot() ;

	Processor &processor( const ProcId & ) ;
	Processor &processor( const string & ) ;

	static const ProcId rootId ;

private:
	typedef map< ProcId, Processor *, less< ProcId > > ProcessorDB ; 

	ProcessorDB procDB ;
	ProcId procIdCount ;

	friend class SingleProcessorAdmin ;
	friend class Root ;

	ProcessorAdmin();	// Default constructor

	ProcessorAdmin &add2DB( Processor *newProc, const ProcId &newId ) ;

	const ProcId newId()
		{return procIdCount++;}

};	// class ProcessorAdmin


// typedef Singleton< ProcessorAdmin > SingleProcessorAdmin ;

class SingleProcessorAdmin
{

public:
	static ProcessorAdmin &Instance() ;

private:
	static ProcessorAdmin *instance ;

} ;

/** inline **/
inline
ProcessorAdmin &SingleProcessorAdmin::Instance()
{
	if( !instance )
		instance = new ProcessorAdmin() ;

	return *instance ;
}

#endif   //__PROCESSOR_ADMIN_H 
