/********************************************************
*	DESCRIPTION	: Log
* 
*	AUTHOR		: Misagh Tavanpour, Jan Mikhail
*	Email		: 
*	DATE		: 30-09-2013
* 
*
********************************************************/


#include "Log.h"

ofstream msgLogFile;
ofstream avgLogFile;
ofstream eventLogFile;
ofstream timeLogFile;


/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: Log
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
Log::Log(){

	LogManager *logManager = static_cast<LogManager*>(&SingleProcessorAdmin::Instance().processor("LogManager").model());

	std::string areaConfig = logManager->areaConfig;
	int frequency = logManager->frequency;
	int bsCounter = logManager->bsCounter;
	int ueCounter = logManager->ueCounter;
	int distanceRange = logManager->distanceRange;

	std::ostringstream oss;

	//message log file
	oss << areaConfig << "/logfile_" << areaConfig << "_" << frequency << "_B" << bsCounter << "_U" << ueCounter << "_D" << distanceRange << ".txt";
	msgLogFile.open(oss.str().c_str(), ios::out);
	oss.str("");

	//average log file
	oss << areaConfig << "/averageLogfile_" << areaConfig << "_" << frequency << "_B" << bsCounter << "_U" << ueCounter << "_D" << distanceRange << ".txt";
	avgLogFile.open(oss.str().c_str(), ios::out);
	oss.str("");

	//event log file
	oss << areaConfig << "/event_"<< areaConfig << "_" << frequency << "_B" << bsCounter << "_U" << ueCounter << "_D" << distanceRange << ".txt";
	eventLogFile.open(oss.str().c_str(), ios::out);
	oss.str("");

	//time, DataRate and RcvPower LogFile log file
	oss << areaConfig << "/time_"<< areaConfig << "_" << frequency << "_B" << bsCounter << "_U" << ueCounter << "_D" << distanceRange << ".txt";
	timeLogFile.open(oss.str().c_str(), ios::out);
	oss.str("");
}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: Log
*Description: Deconstructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
Log::~Log(){
	msgLogFile.close();
	avgLogFile.close();
	eventLogFile.close();
}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: log
*Description: Write into the log file
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
void Log::log(const Time msgTime, std::string src, int srcID, std::string des, int desID, std::string owner, int ownerID, std::string msgType, int index, int msgSize, double dataRate, double rcvPower, float delay, double distance, double speed){
	msgLogFile << msgTime << " " << src << " " << srcID << " " << des << " " << desID << " " << owner << " " << ownerID << " " << msgType << " ";
	if(index == -1){
		msgLogFile << "- ";
	}else{
		msgLogFile << index << " ";
	}
	msgLogFile << msgSize << " " << dataRate << " " << rcvPower << " " << delay << " " << distance << " " << speed << "\n";
}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: logAverage
*Description: Write into the average log file
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
void Log::logAverage(std::string src, int id, int fileSize, int pieceSize, int pieceCount, int avgMsgSize, double avgDataRate, double avgRcvPower, float avgDelay, double avgDistance, double avgSpeed, int numBS){
	avgLogFile <<src<<" "<<id<<" "<<fileSize<<" "<<pieceSize<<" "<<pieceCount<<" "<<avgMsgSize<<" "<<" "<<avgDataRate<<" "<<avgRcvPower<<" "<<avgDelay<<" "<<avgDistance<<" "<<avgSpeed<<" "<<numBS<<endl;
}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: logUploadComplete
*Description: 
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
void Log::logUploadComplete(std::string text){
	eventLogFile << text << endl;
}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: logUploadComplete
*Description: 
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
void Log::logTime(std::string src, int id, double uploadRequestTime, double firstPieceSendTime, double lastPieceSendTime, double rcvDoneBitFieldTime, double dataUploadTime, double totalUploadTime){
	timeLogFile << src << " " << id << " " << uploadRequestTime << " " << firstPieceSendTime << " " << lastPieceSendTime << " " << rcvDoneBitFieldTime << " " << dataUploadTime << " " << totalUploadTime << endl;
}
