 /***********************************************
 *
 *  DESCRIPTION: Atomic Model PeNB Processor 1
 *
 *  AUTHOR: Baha Uddin Kazi, ...
 *
 *  DATE: 15/06/2016
 *
 ***********************************************/

 #ifndef __PeNB_H
 #define __PeNB_H

 #include "atomic.h"   // class Atomic
 #include "string.h"	  // class String
 #include "mainsimu.h"
 #include <iostream>
 #include "Msg.h"
 #include <fstream>


 class PeNB : public Atomic
 {
   public:
	    PeNB ( const std::string &name = "PeNB" );  //Default constructor
	    virtual std::string className() const {  return "PeNB" ;}
	    ~PeNB();

		void initializeParameters(long ID, unsigned long px, unsigned long py, long freq, long pwr);

		void setPosition(int x, int y){ this->posx = x; this->posy = y; }
		long getID(){return id;}
		unsigned long getX(){return posx;}
		unsigned long getY(){return posy;}
		long getPower(){return p;}

		void sendOut(Time time, const Value &value, ValueO *valueO); //May not be needed!!!
		void sendReq(Time time, const Value &value, ValueO *valueO);
		void holdInActive(Time time);
		void passivatePeNB();


   protected:
	    Model &initFunction();
	    Model &externalFunction( const ExternalMessage & );
	    Model &internalFunction( const InternalMessage & );
	    Model &outputFunction( const InternalMessage & );

   private:
	        const Port &In;
		Port &Out, &Req, &X2out;

	    Time ProcessTime;

		Msg* receivedMsg;
		CTRLCmd* CTRLcommand;
		CSIFeedback* CSI;
		MeasurementReport* MR;
		HOReq* HOreq;
		HOReq* recHOreq;
		HOReqAck* HOReqAcknowledgement;
		HOReqAck* recHOReqAcknowledgement;
		RRCConnReconf* RRCcmd;

		std::map <int, bool> MRFlags;
		std::map <int, bool> HOReqFlags;
		std::map <int, bool> HOAckFlags;

		ValueO *valueO;

		int posx, posy, id, f, p, rID, rFreq, rPow,MRtargedID,MRsourceUEid,HOReqSourceUEid,HOReqSourceIDeNB,HOReqtargedID,HOAcksourceUEid,HOAckSourceIDeNB,HOAcktargedID;
		bool ctrlCmdFlag;
		long servingPeNBID, SourceueID;
		long CCSid, UEid;
		
        enum State{
		    Idle,       //initial state
		    SendPack,   //Sending Packet
		    RecPack    //Receiving Traffic Packet

		};
		State state;
		
		ofstream logfile;

 };

#endif
