 /***********************************************
 *
 *  DESCRIPTION: Atomic Model UE Processor
 *
 *  AUTHOR: Baha Uddin Kazi, Mohammad Etemad, Victor Silva
 *
 *  DATE: 15/08/2014
 *
 ***********************************************/

 #ifndef __UE_H
 #define __UE_H

 #include "atomic.h"   // class Atomic
 #include "string.h"	  // class String
 #include "mainsimu.h"
 #include <iostream>
 #include "Msg.h"
 #include <vector>
 #include <fstream>
 #include "Point.h"
 #include "movement.h"
 #include "eNB.h"
 #include <map>

 class UE : public Atomic
 {
   public:
	       UE ( const std::string &name = "UE" );  //Default constructor
	       virtual std::string className() const {  return "UE" ;}
	       ~UE();

		void initializeParameters(long ID, long px, long py, long st, long et);

		void setPosition(int x, int y){ this->posx = x; this->posy = y; }
		long getID(){return id;}

		long getX(){return posx;}
		long getY(){return posy;}

		unsigned long getST(){return startTime;}
		unsigned long getET(){return endTime;}
		
		void sendOut(Time time, const Value &value, ValueO *valueO);
		void holdInActive(Time time);

		float computeDistance(long x, long y, long eNBx, long eNBy);
		float computeRecPower(float d, long f, long MeNBpower, long id); 


   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	    const Port &In;
	    Port &Req;
		Port &Out;
		
		Time ProcessTime;

		Msg* recCommand;
		CTRLCmd* CTRLcommand;
		CoMPCmd* COMPcommand;
		CSIFeedback* CSIfdbck;
		MeasurementReport* MR;
		RRCConnReconf* HOcmd;
		
		long id, maxPowID, countRecPower, NueNB, TeNB,SeNB;
		//long f;
		std::map <long, long> f;
		std::vector<long> ReceivedPower;  
		long posx, posy, posEndx, posEndy, instantX, instantY;
		long startTime, endTime;
		long timeCount;
		bool recMSG, ctrlCmdFlag, firstRun, printMsgCountFlag, HOflag, NormalRunFlag,TTTflag, HOcmdFlag,firstTimeFinalPosition;
		long maximumRecPower;
		long cmdValue, ccsID;
		float dis;
		ValueO *valueO;
		std::vector<long> CSIVectorPows; 
		std::vector<long> CSIVectorIDs;
		long hys,TTT;
		int HODecisionTimer;
		int  countHO,HOCounter;
		long averagePs,averagePn,ActualServingPower,ActualServingID,NewServingPower,NewServingID,
		firstHighPower,firstHighID,secondHighPower,secondHighID; 

		std::vector<long> Ps;
		std::vector<long> Pn;

		int counter, messageCount;
		double time;//seconds
		Point initialPosition;
		Point finalPosition;
		movement mov;
		long SpeedKM_H;
		double SpeedM_S;
		double distanceInitialFinal;
		double angleInitialFinal;
		double traveledD;
		int stopMovFlag;
        std::vector<eNB> eNBs; 	
		enum State{
			            Idle,       //initial state
			            SendPack,   //Sending Packet
			            RecPack    //Receiving Traffic Packet

		              };
		State state;
		ofstream logfile;
 };

#endif
