/*******************************************************************
*
*  DESCRIPTION: class Port
*
*  AUTHOR:    Amir Barylko & Jorge Beyoglonian 
*  Version 2: Daniel A. Rodriguez
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*         mailto://drodrigu@dc.uba.ar
*
*  DATE: 27/6/1998
*  DATE: 28/2/1999 (v2)
*
*******************************************************************/

#ifndef __PORT_H
#define __PORT_H

/** include files **/
#include <list>       // Template list
#include <string>    // class string 
#include "modelid.h"   // class ModelId

using namespace std;
/** foward declarations **/
class Port;
class Coupled ;

/** definitions **/

typedef Port Influence ;

typedef const Influence* CPInf ;

typedef list<CPInf> InfluenceList;
typedef int PortId ;

class Port
{
public:
	Port( const string & , const ModelId & ) ;  // Default constructor

	const InfluenceList &influences() const
		{ return influenceList; }

	const string &name() const
		{ return pname; }
		
	Port &name( const string & ) ;

	const PortId &id() const
		{ return pid; }

	const ModelId &model() const
		{ return mid; }

	bool operator ==( const Port &port ) const	 // Equality operator
		{ return pid == port.id(); }

	const string asString() const
		{ return pname; }

protected:
	Port(const Port&);					// Copy constructor
	Port& operator=( const Port& );	// Assignment operator

private:
	friend class Coupled ;

	InfluenceList influenceList;
	PortId pid ;
	string pname ;
	const ModelId &mid ;
	static int idCount ;

	Port &addInfluence( const Influence & );

};	// class Port

#endif   //__PORT_H 
