/********************************************************
*	DESCRIPTION	: MetaInfoFile
* 
*	AUTHOR		: Misagh Tavanpour, Jan Mikhail
*	Email		: 
*	DATE		: 18-08-2013
* 
*
********************************************************/



#include <exception>
#include "MetaInfoFile.h"

#define MSG_SIZE_BASE 64

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*Function Name: MetaInfoFile
*Description: Constructor
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
MetaInfoFile::MetaInfoFile(short srcType, long src, short destType, long dest, int Length, std::string Name, int PieceLength, unsigned char *Pieces):
	Msg(srcType, src, destType, dest, MSG_METAINFO){
	//cout << "MetaInfoFile constructor called" << endl;
	this->length = Length;
	this->name = Name;
	this->pieceLength = PieceLength;
	this->pieces = Pieces;
}

MetaInfoFile::~MetaInfoFile(){
	//cout << "MetaInfoFile destructor called" << endl;
}

int MetaInfoFile::getFileSize(){
	int numberOfPieces = (this->length + this->pieceLength - 1) / this->pieceLength; //calculate number of pieces

	int size = MSG_SIZE_BASE;
	size += 4 * 8; //length
	size += this->name.length() * 8; //name
	size += 4 * 8; //pieceLength
	size += numberOfPieces * 20 * 8; //pieces
	return size;
}
