/*******************************************************************
*
*  DESCRIPTION: class TransportDelayCell
*
*  AUTHOR: Amir Barylko & Jorge Beyoglonian
*  Version 2: Daniel Rodriguez
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*         mailto://drodrigu@dc.uba.ar
*
*  DATE: 27/06/1998
*  DATE: 02/03/1999 (v2)
*
*******************************************************************/

#ifndef __TRANSPORT_DELAY_ATOMIC_CELL_H
#define __TRANSPORT_DELAY_ATOMIC_CELL_H

/** include files **/
#include <list>
#include <utility>
#include "atomcell.h"         // base class header

/** foward declarations **/

#define	TRANSPORT_DELAY_CELL_NAME	"TransportDelayCell"

/** declarations **/
class TransportDelayCell: public AtomicCell
{
public:
	TransportDelayCell( const string & = "TrasnportDelayCell" , const LocalTransAdmin::Function &fn = LocalTransAdmin::InvalidFn ) ;

	string className() const;
	
protected:
	Model &internalFunction( const InternalMessage & ) ;
	Model &externalFunction( const ExternalMessage & ) ;
	Model &outputFunction( const InternalMessage & ) ;

public:   
	typedef pair< Time, Real > QueueElement ;
	typedef list< QueueElement > Queue ;

private:
	Queue queueVal ;

	const Time & firstQueuedTime() const;
	const Real & firstQueuedValue() const;
	TransportDelayCell & updateRemainingTime( const Time & );
	TransportDelayCell & insertByTime( const Time &, const Real & );

} ;  // TransportDelayCell

/** inline **/

inline
string TransportDelayCell::className() const
{
	return TRANSPORT_DELAY_CELL_NAME;
}

#endif // __TRANSPORT_DELAY_ATOMIC_CELL_H
