/*****************************************************************************
*  	DESCRIPTION	: Atomic Model globalQueue
*	AUTHOR		: Baha Uddin Kazi, Mohammad Etemad
*	Email		: 
*	DATE		: 
*****************************************************************************/

#ifndef __BSQUEUE_H
#define __BSQUEUE_H

#include "atomic.h"     // class Atomic
#include "string.h"	 // class String
#include <list>
#include "Msg.h"
#include "mainsimu.h"
 #include <fstream>

class globalQueue : public Atomic
{
	public:
		globalQueue( const std::string &name = "globalQueue" );	//Default constructor
		virtual std::string className() const { return "globalQueue"; }
		~globalQueue();

		int getID(){ return this->id; }

	protected:
	        Model &initFunction();
	        Model &externalFunction( const ExternalMessage & );
	        Model &internalFunction( const InternalMessage & );
		Model &outputFunction( const InternalMessage & );

	private:
		int id;

	        const Port &In,&Req,&X2in;
	        Port &Out;
	        Time ProcessTime;
	        typedef list<Value> ElementList ;
	        ElementList elements;
	        typedef list<ValueO*> ElementListO ;
	        ElementListO elementsO;
	        int Request;
	        int Qlen;
         	enum State{
			Idle,  //initial state
			Push,
			Pop,
		    Send
			};
		State state;

		ofstream logfile;

};

#endif   //__globalQueue_H

