/*******************************************************************
*
*  DESCRIPTION: class InertialDelayCell
*
*  AUTHOR:    Amir Barylko & Jorge Beyoglonian 
*  Version 2: Daniel Rodriguez.
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*         mailto://drodrigu@dc.uba.ar
*
*  DATE: 27/6/1998
*  DATE: 17/9/1999 (v2)
*
*******************************************************************/

#ifndef __INERTIAL_DELAY_ATOMIC_CELL_H
#define __INERTIAL_DELAY_ATOMIC_CELL_H

/** include files **/
#include "atomcell.h"         // base class header

/** foward declarations **/
#define	INERTIAL_DELAY_CELL_NAME	"InertialDelayCell"

/** declarations **/
class InertialDelayCell: public AtomicCell
{
public:
	InertialDelayCell( const string &name = "InertialDelayCell" , const LocalTransAdmin::Function &fn = LocalTransAdmin::InvalidFn )
			: AtomicCell( name, fn )
			, futureValue(0)
			, actualValue(0)
			{}

	string className() const
			{return INERTIAL_DELAY_CELL_NAME;}
	
protected:
	Model &internalFunction( const InternalMessage & )
			{ passivate(); return *this; }
			
	Model &externalFunction( const ExternalMessage & ) ;

	Model &outputFunction( const InternalMessage & );
private:

	Real	futureValue;
	Real	actualValue;
} ;  // InertialDelayCell

#endif // __INERTIAL_DELAY_ATOMIC_CELL_H
