/********************************************************
*	DESCRIPTION	: Atomic model BSRegistryr
* 
*	AUTHOR		: Mohammad Moallemi
*	Email		: moallemi@sce.carleton.ca
*	DATE		: 27-08-2012
* 
*
********************************************************/


#ifndef BSREGISTRY_H
#define BSREGISTRY_H

#include "atomic.h"
#include "MeNB.h"

class BSList;
class BS;

using namespace std;

struct SIMModel {
	enum Type {
		UTRAFDD,    //UTRA FDD                    	0
		UTRA128TDD, //UTRA 1.28Mcps TDD			1
		UTRA384TDD, //UTRA 3.84 Mcps TDD		2
		EUTRAFDDTDD //E-UTRA FDD and E-UTRA TDD		3	
     	};
     	Type t_;
     	SIMModel(Type t) : t_(t) {}
     	operator Type () const {return t_;}

	private:
		//prevent automatic conversion for any other built-in types such as bool, int, etc
		template<typename T>
		operator T () const;
};


class BSRegistry: public Atomic {

	public: 
	
		BSList *bslist;  // list of network BSs implemented in a linkedlist(see BSs.h and BSs.cpp)
	
		BSRegistry(const string &name = "BSRegistry");
		~BSRegistry();
		virtual string className() const
			{return "BSRegistry";}
		long getBSNum(){return BSId - 1;}
		void addBS(BS *bs);

	protected:
		Model &initFunction();
	
		Model &externalFunction( const ExternalMessage & );
	
		Model &internalFunction( const InternalMessage & );
	
		Model &outputFunction( const InternalMessage &);
	
	private:

		friend class UERegistry;
		//void createAndMountBSs();

		static long cellRadius; //R is the cell radius meters
	
		static int defaultBSs; //the number of network BSs at the start of simulation
		static const double t = 1.0; //the time after which the BSs are to be updated in seconds
		Port &gen, &deq;
		Port &pos;
		Port &aout;
		Time idleTime;
		long BSId;

		enum State{         
			initial,  //initial state
			idle,
			generateBS
		};
		State state;
};

#endif  //_BSREGISTRY_H
