/*******************************************************************
*
*  DESCRIPTION: class NetworkLoad
*
*  AUTHOR: Amir Barylko & Jorge Beyoglonian 
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*
*  DATE: 27/6/1998
*
*******************************************************************/

/** include files **/
#include <strstream>
#include <functional>      // Warning!!! must be included before string (for operator !=)
#include <string>
#include "netload.h"       // bass class
#include "bsdchann.h"      // class BSDChannel
#include <assert.h>
#include <string.h>

/** public functions **/

/*******************************************************************
* Function Name: NetworkLoader
* Description: Constructor
********************************************************************/
NetworkLoader::NetworkLoader()
: delimitator( "." )
{
	commChannel = new BSDChannel("simulator");	 // get the port
	assert( commChannel );
}

/*******************************************************************
* Function Name: ~NetworkLoader
* Description: Destructor
********************************************************************/
NetworkLoader::~NetworkLoader()
{
	assert( commChannel );
	delete commChannel ;

	delete models ; models = NULL ;
	delete events ; events = NULL ;
	delete output ; output = NULL ;
	delete log ; log = NULL ;
}

/*******************************************************************
* Function Name: loadData
* Description: 
********************************************************************/
SimLoader &NetworkLoader::loadData()
{
	string line;

	strstream *outModels = new strstream ;   
	while( ( line = commChannel->readLine() ) != NetworkLoader::delimitator )
		*outModels << line << endl;

	models = outModels ;

	strstream *outEvents = new strstream;
	while( (line = commChannel->readLine()) != NetworkLoader::delimitator ) 
		*outEvents << line << endl;

	events = outEvents ;

	stopTime( Time( commChannel->readLine() ) );

	output = new strstream ;
	log  = new strstream ;

	return *this ;
}


/*******************************************************************
* Function Name: writeResults
* Description: 
********************************************************************/
SimLoader &NetworkLoader::writeResults()
{
	char line[1024] ;

	strstream &ilog( static_cast< strstream & >( *log ) ) ; 

	ilog.seekg( ios::beg ) ;

	while( ! ilog.eof() )
	{
		ilog.getline( line, 1024 ) ;
		commChannel->writeLine( string( line ) ) ;
	}

	commChannel->writeLine( NetworkLoader::delimitator ) ;

	strstream &ioutput( static_cast< strstream & >( *output ) ) ; 

	ioutput.seekg( ios::beg ) ;

	while( ! ioutput.eof() )
	{
		ioutput.getline( line, 1024 ) ;
		commChannel->writeLine( string( line ) ) ;
	}

	commChannel->writeLine( NetworkLoader::delimitator ) ;

	return *this ;
}
