#include(HFMacrosCase4b.inc)

[top]
components : HydrauFracture

[HydrauFracture]
type : cell
dim : (100,100)
delay : transport
defaultDelayTime : 100
border : nowrapped

neighbors : HydrauFracture(-1,-1) HydrauFracture(-1,0) HydrauFracture(-1,1)
neighbors : HydrauFracture(0,-1) HydrauFracture(0,0) HydrauFracture(0,1)
neighbors : HydrauFracture(1,-1) HydrauFracture(1,0) HydrauFracture(1,1)

initialValue : 0

%Ports for stateport, pressureport and directionport variables
neighborports : stateport pressureport directionport

localtransition : hfrule

zone : wellspout { (49,1) }

[wellspout]
%Rule for the well spout cell 
rule : { ~directionport := randInt(8); ~pressureport := #macro(FracturedCellpressure) + 1000000; ~stateport := 2;} 100 {t}

[hfrule]
rule : { ~stateport := 1; ~pressureport := 1; ~directionport := randInt(8); } 100 { ((0,0)~stateport = 0) and ((-1,-1)~pressureport > #macro(MaxpressureSupport)*(1 + 10 * ((8 - #macro(ResistanceFactor))/8))) and ((-1,-1)~directionport = (0,0)~directionport) and (statecount(1, ~stateport) < 2) }
rule : { ~stateport := 1; ~pressureport := 1; ~directionport := randInt(8); } 100 { ((0,0)~stateport = 0) and ((-1,0)~pressureport > #macro(MaxpressureSupport)*(1 + 10 * ((8 - #macro(ResistanceFactor))/8))) and ((-1,0)~directionport = (0,0)~directionport) and (statecount(1, ~stateport) < 2) }
rule : { ~stateport := 1; ~pressureport := 1; ~directionport := randInt(8); } 100 { ((0,0)~stateport = 0) and ((-1,1)~pressureport > #macro(MaxpressureSupport)*(1 + 10 * ((8 - #macro(ResistanceFactor))/8))) and ((-1,1)~directionport = (0,0)~directionport) and (statecount(1, ~stateport) < 2) }
rule : { ~stateport := 1; ~pressureport := 1; ~directionport := randInt(8); } 100 { ((0,0)~stateport = 0) and ((0,-1)~pressureport > #macro(MaxpressureSupport)*(1 + 10 * ((8 - #macro(ResistanceFactor))/8))) and ((0,-1)~directionport = (0,0)~directionport) and (statecount(1, ~stateport) < 2) }
rule : { ~stateport := 1; ~pressureport := 1; ~directionport := randInt(8); } 100 { ((0,0)~stateport = 0) and ((0,1)~pressureport > #macro(MaxpressureSupport)*(1 + 10 * ((8 - #macro(ResistanceFactor))/8))) and ((0,1)~directionport = (0,0)~directionport) and (statecount(1, ~stateport) < 2) }
rule : { ~stateport := 1; ~pressureport := 1; ~directionport := randInt(8); } 100 { ((0,0)~stateport = 0) and ((1,-1)~pressureport > #macro(MaxpressureSupport)*(1 + 10 * ((8 - #macro(ResistanceFactor))/8))) and ((1,-1)~directionport = (0,0)~directionport) and (statecount(1, ~stateport) < 2) }
rule : { ~stateport := 1; ~pressureport := 1; ~directionport := randInt(8); } 100 { ((0,0)~stateport = 0) and ((1,0)~pressureport > #macro(MaxpressureSupport)*(1 + 10 * ((8 - #macro(ResistanceFactor))/8))) and ((1,0)~directionport = (0,0)~directionport) and (statecount(1, ~stateport) < 2) }
rule : { ~stateport := 1; ~pressureport := 1; ~directionport := randInt(8); } 100 { ((0,0)~stateport = 0) and ((1,1)~pressureport > #macro(MaxpressureSupport)*(1 + 10 * ((8 - #macro(ResistanceFactor))/8))) and ((1,1)~directionport = (0,0)~directionport) and (statecount(1, ~stateport) < 2) }

%rule for a fractured cell
rule : { ~stateport := 1; ~pressureport := #macro(FracturedCellpressure); ~directionport := randInt(8); } 100  { (0,0)~pressureport > 0 } 

rule : { ~stateport := 0; ~pressureport := 0; ~directionport := randInt(8); } 100 { t }

