
 #include "myProcessor.h"  // class myProcessor
 #include "message.h"    // class ExternalMessage, InternalMessage

 #include <iostream>
 #include <fstream>
 #include "mainsimu.h"

 ofstream ProcessorI ("Processor_In.txt");
 ofstream ProcessorO ("Processor_Out.txt");

 myProcessor::myProcessor( const string &name ) : Atomic( name )
 , In( addInputPort( "In" ) )
 , Ask( addOutputPort( "Ask" ) )
 , Out( addOutputPort( "Out" ) )
 , ProcessTime (00,00,00,02)
 {
	string UnitID( MainSimulator::Instance().getParameter( description(), "id" ) ) ;
	if (UnitID!="") id = atol(UnitID.c_str());
 }

 Model &myProcessor::initFunction(){
	 askForTask = 1;
	 msgCounter = 0;
	 isGenerator = rand() % 2; //0 or 1
	 if (isGenerator == 0){
		 state = Idle;
		 cout << "Unit " << id << " is NOT a packet Generator" << endl;
	 }
	 else {
		 state = Generate;
		 cout << "Unit " << id << " is a packet Generator" << endl;
	 }
	 holdIn( Atomic::active, 0); //activate the Atomic model
return *this ;
 }

 Model &myProcessor::externalFunction( const ExternalMessage &msg ){\
   ProcessorI <<"Unit " << id <<" Processor received '" << msg.value() << "' from port 'In' at " << msg.time() << endl;
   if( msg.port() == In ){ //Input from In
	   state = Task;
	   holdIn( Atomic::active, ProcessTime);
   }
   return *this;
 }

 Model &myProcessor::outputFunction( const InternalMessage &msg ){
   if (state == Generate && msgCounter > 0){
	   ProcessorO <<"Unit " << id <<" Processor sent '" << msgToSend << "' to port 'Out' at " << msg.time() << endl;
	   sendOutput( msg.time(), Out, msgToSend);  //Send out data from myProcessor to Interface
	  }
   if (askForTask == 1){
	   askForTask = 0;
	   ProcessorO <<"Unit " << id <<" Processor sent 1 to port 'Ask' at " << msg.time() << endl;
	   sendOutput( msg.time(), Ask, 1);  //Send out data from myProcessor to Interface
   }
   return *this ;
 }

 Model &myProcessor::internalFunction( const InternalMessage & ){
   switch (state){
   				    case Idle:
   				    			passivate();
   				    			break;

   				    case Task:
   				    			if (isGenerator == 0 || msgCounter > 10){
   				    				state = Idle;
   				    			}
   				    			else {
   				    				state = Generate;
   				    			}
   				    			askForTask = 1;
   					            break;

   				    case Generate:
   				    		   msgToSend = (rand() % 4) + 1; //create a number 1 to 4
   				    		   msgCounter = msgCounter + 1;
   				    		   if (msgCounter > 10) {
   				    			   state = Idle;
   				    		   }
   				    		   else {
   				    			   holdIn( Atomic::active, ProcessTime);
   				    		   }
   					           break;
           		 }
   return *this;
 }

 myProcessor::~myProcessor(){
 }
