
 #include "Buffer.h"     // class Buffer
 #include "message.h"    // class ExternalMessage, InternalMessage

 #include <iostream>
 #include <fstream>
 #include "mainsimu.h"

 ofstream BufferI ("Buffer_In.txt");
 ofstream BufferO ("Buffer_Out.txt");

 Buffer::Buffer( const string &name ) : Atomic( name )
 , In( addInputPort( "In" ) )
 , Ask( addInputPort( "Ask" ) )
 , Out( addOutputPort( "Out" ) )
 , ProcessTime (00,00,00,00)
 {
	string UnitID( MainSimulator::Instance().getParameter( description(), "id" ) ) ;
	if (UnitID!="") id = atol(UnitID.c_str());
 }

 Model &Buffer::initFunction(){
   Request = 0;
   Qlen = 0;
   state = Idle;
   elements.erase( elements.begin(), elements.end() ) ;
   passivate();
   return *this ;
 }

 Model &Buffer::externalFunction( const ExternalMessage &msg ){

   if( msg.port() == In ) //Input from In
	 {
	   BufferI <<"Unit " << id <<" Buffer received '" << msg.value() << "' from port 'In' at " << msg.time() << endl;
	   elements.push_back( msg.value() ) ; //Store Input value in Queue
	   state = Push;
	   Qlen++;
	   holdIn( Atomic::active, ProcessTime);
	 }
     else if (msg.port() == Ask){
    	 BufferI <<"Unit " << id <<" Buffer received '" << msg.value() << "' from port 'Ask' at " << msg.time() << endl;
    	 if (elements.size() > 0)  //Pop from Queue (Check that the Queue is not empty)
          	 {
    	       Request = 1;
    	       state = Pop;
    	       holdIn( Atomic::active, ProcessTime);
      	     }
             else if (elements.size() == 0)
            	     {      //Here this two condition are True :(msg.port() == Ask) & (elements.size() == 0)
            	       Request = 1;   //Although Buffer is empty but remember that server is waiting for input.
            	       passivate();   //If the Buffer is empty then passivate.
            	     }
     }
   return *this;
 }

 Model &Buffer::outputFunction( const InternalMessage &msg ){
   if ((state == Pop) && (Request == 1)){
	     BufferO <<"Unit " << id <<" Buffer sent '" << elements.front() << "' to port 'Out' at " << msg.time() << endl;
	     sendOutput( msg.time(), Out, elements.front());  //Send out data from Buffer
	  }
   return *this ;
 }

 Model &Buffer::internalFunction( const InternalMessage & ){
   switch (state){
   				    case Idle:
   				    	       if (Request == 1) state = Pop;
   				    	         else passivate();
   					           break;

   				    case Push:
 			    	            state = Idle;
   					            break;

   				    case Pop:
   				    	       elements.pop_front();
   				    	       Qlen--;
   				    	       Request = 0;
   				    	       state = Idle;
   					           break;
           		 }
   return *this;
 }

 Buffer::~Buffer(){
 }
