
 #include "Interface.h"  // class Interface
 #include "message.h"    // class ExternalMessage, InternalMessage

 #include <iostream>
 #include <fstream>
 #include "mainsimu.h"

 ofstream InterfaceI ("Interface_In.txt");
 ofstream InterfaceO ("Interface_Out.txt");

 Interface::Interface( const string &name ) : Atomic( name )
 , In1( addInputPort( "In1" ) )
 , In2( addInputPort( "In2" ) )
 , In3( addInputPort( "In3" ) )
 , Out1( addOutputPort( "Out1" ) )
 , Out2( addOutputPort( "Out2" ) )
 , Out3( addOutputPort( "Out3" ) )
 , ProcessTime (00,00,00,01)
 {
	string UnitID( MainSimulator::Instance().getParameter( description(), "id" ) ) ;
	if (UnitID!="") id = atol(UnitID.c_str());
 }

 Model &Interface::initFunction(){
	 state = Idle;
	 passivate();
	 return *this ;
 }

 Model &Interface::externalFunction( const ExternalMessage &msg ){
   if( msg.port() == In1 ){//input from Unit Processor
	   fromNet = 0;
	   InterfaceI <<"Interface " << id <<" received '" << msg.value() << "' from port 'In1' at " << msg.time() << endl;
   }
   if( msg.port() == In2 ){//input from Network
	   fromNet = 1;
	   InterfaceI <<"Interface " << id <<" received '" << msg.value() << "' from port 'In2' at " << msg.time() << endl;
   }
   if( msg.port() == In3 ){//input from Network
	   fromNet = 1;
	   InterfaceI <<"Interface " << id <<" received '" << msg.value() << "' from port 'In3' at " << msg.time() << endl;
   }
   temp = msg.value();
   state = Forward;
   holdIn( Atomic::active, ProcessTime);
   return *this;
 }

 Model &Interface::outputFunction( const InternalMessage &msg ){
   if (state == Forward){
	   if (fromNet == 1){//send the received msg from the network to the buffer of the Unit
		   InterfaceO <<"Node " << id <<" Interface sent '" << temp << "' to the buffer at " << msg.time() << endl;
		   sendOutput( msg.time(), Out1, temp);
	   }
	   else if (fromNet == 0){//send the received msg from the buffer to the Network
		   	   if (rand()%2 == 0){//select a port randomly
		   		   InterfaceO <<"Node " << id <<" Interface sent '" << temp << "' to the Network through port 'Out2' at " << msg.time() << endl;
		   		   sendOutput( msg.time(), Out2, temp);
		   	   }
		   	   else{
		   		   InterfaceO <<"Node " << id <<" Interface sent '" << temp << "' to the Network through port 'Out3' at " << msg.time() << endl;
		   		   sendOutput( msg.time(), Out3, temp);
		   	   }
	   }
   }
   return *this ;
 }

 Model &Interface::internalFunction( const InternalMessage & ){
	   switch (state){
	   				    case Idle:
	   				    			passivate();
	   				    			break;

	   				    case Forward:
	   				    			state = Idle;
	   					            break;
	           		 }
   return *this;
 }

 Interface::~Interface(){
 }
