/*******************************************************************
*
*  DESCRIPTION:
*
*  AUTHOR:
*
*  EMAIL:
*
*  DATE:
*
*******************************************************************/

/** include files **/
#include "calcAisles.h"      // class CalcAisles
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name:
* Description:
********************************************************************/
CalcAisles::CalcAisles( const string &name )
: Atomic( name )
, onReset( addInputPort( "onReset" ) )
, update( addOutputPort( "update" ) )
, preparationTime( 0, 0,15, 0 )

{
}

/*******************************************************************
* Function Name: initFunction
* Description:
* Precondition:
********************************************************************/
Model &CalcAisles::initFunction()
{
	holdIn( passive, Time::Zero );
	ifupdate = false ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &CalcAisles::externalFunction( const ExternalMessage &msg )
{

	if ( msg.port() == onReset )
		{
			ifupdate = true ;
			holdIn ( active, Time::Zero ) ;
		}

		return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &CalcAisles::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &CalcAisles::outputFunction( const InternalMessage &msg )
{
		if ( ifupdate == true )
		{
				sendOutput( msg.time(), update, true ) ;
		}

		return *this ;
}
